// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : PS4 ANDROID LINUX32 LINUX64 NX32 NX64 MAC IOS
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#if defined(HK_ARCH_INTEL)
#include <immintrin.h>
#endif

#define HK_NOT_LOCKFREE_MSG "Atomic operations on values of the given size not guaranteed to be lock free."

namespace hkAtomic
{
    namespace Detail
    {
        template <int size>
        HK_INLINE bool HK_CALL compareAndSwap(
            typename Storage<size>::Type* address,
            typename Storage<size>::Type* curValue,
            typename Storage<size>::Type newValue)
        {
            static_assert(__atomic_always_lock_free(size, address), HK_NOT_LOCKFREE_MSG);
            return __atomic_compare_exchange_n(address, curValue, newValue, false, __ATOMIC_SEQ_CST, __ATOMIC_SEQ_CST);
        }

        template <int size>
        HK_INLINE bool HK_CALL compareAndSwapBool(
            typename Storage<size>::Type* address,
            typename Storage<size>::Type curValue,
            typename Storage<size>::Type newValue)
        {
            static_assert(__atomic_always_lock_free(size, address), HK_NOT_LOCKFREE_MSG);
            return __atomic_compare_exchange_n(address, &curValue, newValue, false, __ATOMIC_SEQ_CST, __ATOMIC_SEQ_CST);
        }

        template <int size>
        HK_INLINE typename Storage<size>::Type HK_CALL compareAndSwapVal(
            typename Storage<size>::Type* address,
            typename Storage<size>::Type oldValue,
            typename Storage<size>::Type newValue)
        {
            static_assert(__atomic_always_lock_free(size, address), HK_NOT_LOCKFREE_MSG);
            __atomic_compare_exchange_n(address, &oldValue, newValue, false, __ATOMIC_SEQ_CST, __ATOMIC_SEQ_CST);
            return oldValue;
        }

#if defined(HK_ARCH_IA32) || (defined(HK_ARCH_ARM) && !defined(HK_ARCH_ARM_64))
        template <>
        HK_INLINE bool HK_CALL compareAndSwap<8>(hkUint64* address, hkUint64* curValue, hkUint64 newValue)
        {
            hkUint64 curValueLocal = *curValue;
            hkUint64 oldValue = __sync_val_compare_and_swap(address, curValueLocal, newValue);
            if(oldValue == curValueLocal)
            {
                return true;
            }
            else
            {
                *curValue = oldValue;
                return false;
            }
        }

        template <>
        HK_INLINE bool HK_CALL compareAndSwapBool<8>(hkUint64* address, hkUint64 curValue, hkUint64 newValue)
        {
            return __sync_bool_compare_and_swap(address, curValue, newValue);
        }

        template <>
        HK_INLINE hkUint64 HK_CALL compareAndSwapVal<8>(hkUint64* address, hkUint64 oldValue, hkUint64 newValue)
        {
            return __sync_val_compare_and_swap(address, oldValue, newValue);
        }
#endif

        template <>
        HK_INLINE hkUint8 exchangeAdd<1>(hkUint8* address, hkUint8 b)
        {
            static_assert(__atomic_always_lock_free(1, address), HK_NOT_LOCKFREE_MSG);
            return __atomic_fetch_add(address, (hkUint8)b, __ATOMIC_SEQ_CST);
        }

        template <>
        HK_INLINE hkUint32 exchangeAdd<4>(hkUint32* address, hkUint32 b)
        {
            static_assert(__atomic_always_lock_free(4, address), HK_NOT_LOCKFREE_MSG);
            return __atomic_fetch_add(address, (hkUint32)b, __ATOMIC_SEQ_CST);
        }

#if defined(HK_ARCH_X64) || defined(HK_ARCH_ARM_64)
        template <>
        HK_INLINE hkUint64 exchangeAdd<8>(hkUint64* address, hkUint64 b)
        {
            static_assert(__atomic_always_lock_free(8, address), HK_NOT_LOCKFREE_MSG);
            return __atomic_fetch_add(address, (hkUint64)b, __ATOMIC_SEQ_CST);
        }
#endif

        template <int size>
        HK_INLINE typename Storage<size>::Type swap(
            typename Storage<size>::Type* address,
            typename Storage<size>::Type newValue)
        {
            static_assert(__atomic_always_lock_free(size, address), HK_NOT_LOCKFREE_MSG);
            return __atomic_exchange_n(address, newValue, __ATOMIC_SEQ_CST);
        }

        template <int size>
        HK_ALWAYS_INLINE typename Storage<size>::Type loadRelaxed(const typename Storage<size>::Type* address)
        {
            static_assert(__atomic_always_lock_free(size, address), HK_NOT_LOCKFREE_MSG);
            return __atomic_load_n(address, __ATOMIC_RELAXED);
        }

        template <int size>
        HK_ALWAYS_INLINE typename Storage<size>::Type loadAcquire(const typename Storage<size>::Type* address)
        {
            static_assert(__atomic_always_lock_free(size, address), HK_NOT_LOCKFREE_MSG);
            return __atomic_load_n(address, __ATOMIC_ACQUIRE);
        }

        template <int size>
        HK_ALWAYS_INLINE typename Storage<size>::Type loadSeqCst(const typename Storage<size>::Type* address)
        {
            static_assert(__atomic_always_lock_free(size, address), HK_NOT_LOCKFREE_MSG);
            return __atomic_load_n(address, __ATOMIC_SEQ_CST);
        }

        template <int size>
        HK_ALWAYS_INLINE void storeRelaxed(typename Storage<size>::Type* address, typename Storage<size>::Type value)
        {
            static_assert(__atomic_always_lock_free(size, address), HK_NOT_LOCKFREE_MSG);
            __atomic_store_n(address, value, __ATOMIC_RELAXED);
        }

        template <int size>
        HK_ALWAYS_INLINE void storeRelease(typename Storage<size>::Type* address, typename Storage<size>::Type value)
        {
            static_assert(__atomic_always_lock_free(size, address), HK_NOT_LOCKFREE_MSG);
            __atomic_store_n(address, value, __ATOMIC_RELEASE);
        }

        template <int size>
        HK_ALWAYS_INLINE void storeSeqCst(typename Storage<size>::Type* address, typename Storage<size>::Type value)
        {
            static_assert(__atomic_always_lock_free(size, address), HK_NOT_LOCKFREE_MSG);
            __atomic_store_n(address, value, __ATOMIC_SEQ_CST);
        }
    }

    HK_INLINE void pauseTicks( int numTicks )
    {
        for (int n = numTicks; n > 0; n--)
        {
#if defined(HK_ARCH_INTEL)
            _mm_pause();
#elif defined ( HK_ARCH_ARM )
            __asm__ __volatile__ ("dmb ishst");
            __asm__ __volatile__ ("yield");
#else
#error pauseTicks not implemented for this platform
#endif
        }
    };

    HK_INLINE void HK_CALL readWriteBarrier()
    {
        __atomic_thread_fence(__ATOMIC_SEQ_CST);
    };
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
