// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Types/hkBaseDefs.h>

/// Computes an approximation of the median of a stream of values.
template <typename T>
class HK_EXPORT_COMMON hkRunningApproxMedian
{
public:
    hkRunningApproxMedian();

    /// Add a sample to the set of values to compute the approximate median of.
    void addSample(T sample);

    /// Combines this hkRunningApproxMedian with another one. This results in an
    /// approximation of the median of the combined sets of input values (though
    /// the resulting median may differ slightly from the approximated median of
    /// all input values were fed to a single hkRunningApproxMedian).
    void combine(const hkRunningApproxMedian& b);

    /// Gives the resulting approximate median as the fraction mediansSumOut / numMediansOut.
    void getMedian(T& mediansSumOut, int& numMediansOut) const;

private:
    static const int WINDOW_SIZE = 7;

    int m_numSamples;
    int m_numMedians;

    T m_samples[WINDOW_SIZE];
    T m_mediansSum;
};

#ifdef HK_DYNAMIC_DLL
HK_EXPORT_COMMON_TEMPLATE_SPECIALIZATION template class HK_EXPORT_COMMON hkRunningApproxMedian<hkFloat32>;
HK_EXPORT_COMMON_TEMPLATE_SPECIALIZATION template class HK_EXPORT_COMMON hkRunningApproxMedian<hkDouble64>;
HK_EXPORT_COMMON_TEMPLATE_SPECIALIZATION template class HK_EXPORT_COMMON hkRunningApproxMedian<hkUint64>;
#else
extern template class HK_EXPORT_COMMON hkRunningApproxMedian<hkFloat32>;
extern template class HK_EXPORT_COMMON hkRunningApproxMedian<hkDouble64>;
extern template class HK_EXPORT_COMMON hkRunningApproxMedian<hkUint64>;
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
