// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Thread/Async/hkRunningApproxMedian.h>
#include <Common/Base/Algorithm/Sort/hkSort.h>

template <typename T>
hkRunningApproxMedian<T>::hkRunningApproxMedian()
    : m_numSamples(0),
    m_numMedians(0),
    m_mediansSum(0)
{
}

template <typename T>
void hkRunningApproxMedian<T>::addSample(T sample)
{
    m_samples[m_numSamples++] = sample;
    if(m_numSamples == WINDOW_SIZE)
    {
        T median = hkAlgorithm::nthElement(m_samples, WINDOW_SIZE, WINDOW_SIZE / 2);

        m_numSamples = 0;
        m_numMedians++;
        m_mediansSum += median;
    }
}

template <typename T>
void hkRunningApproxMedian<T>::combine(const hkRunningApproxMedian& b)
{
    m_mediansSum += b.m_mediansSum;
    m_numMedians += b.m_numMedians;

    for(int i = 0; i < b.m_numSamples; i++)
    {
        addSample(b.m_samples[i]);
    }
}

template <typename T>
void hkRunningApproxMedian<T>::getMedian(T& mediansSumOut, int& numMediansOut) const
{
    mediansSumOut = m_mediansSum;
    numMediansOut = m_numMedians;

    if(m_numSamples)
    {
        T median = hkAlgorithm::nthElement(const_cast<T*>(m_samples), m_numSamples, m_numSamples / 2);
        mediansSumOut += median;
        numMediansOut++;
    }
}

template class hkRunningApproxMedian<hkFloat32>;
template class hkRunningApproxMedian<hkDouble64>;
template class hkRunningApproxMedian<hkUint64>;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
