// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Thread/Async/hkAsyncThreadPoolLocking.h>
#include <Common/Base/Thread/Async/hkAsyncThreadPool.h>
#include <Common/Base/Thread/Semaphore/hkSemaphore.h>

void hkAsyncThreadPoolSimpleSemaphore::acquire(hkAsyncThreadPool* threadPool, int threadIdx)
{
    HK_ASSERT_NO_MSG(0x46764511, hkAsyncThreadPool::getCurrentThreadPool() == threadPool);
    HK_ASSERT_NO_MSG(0x32770616, hkAsyncThreadPool::getCurrentThreadIndex() == threadIdx);

    hkInt32 newCount = --m_count;
    if(newCount < 0)
    {
        threadPool->acquireThreadSemaphore();
    }
}

void hkAsyncThreadPoolSimpleSemaphore::release(hkAsyncThreadPool* threadPool, int threadIdx)
{
    hkInt32 oldCount = m_count++;
    if(oldCount < 0)
    {
        threadPool->releaseThreadSemaphore(threadIdx);
    }
}

hkAsyncThreadPoolMutex::hkAsyncThreadPoolMutex()
    : m_numContenders(0),
    m_queueHead(nullptr),
    m_queueTail(nullptr)
{
}

hkAsyncThreadPoolMutex::~hkAsyncThreadPoolMutex()
{
}

void hkAsyncThreadPoolMutex::enter()
{
    hkInt32 numContenders = m_numContenders.loadRelaxed();
    while(true)
    {
        if(numContenders == 0)
        {
            if(m_numContenders.compareAndSwap(numContenders, 1))
            {
                break;
            }
        }
        else
        {
            m_queueLock.enter();

            if(m_numContenders.compareAndSwap(numContenders, numContenders + 1))
            {
                WaitingQueueItem waitingQueueItem;
                waitingQueueItem.m_next = nullptr;

                hkAsyncThreadPool* threadPool = hkAsyncThreadPool::getCurrentThreadPool();
                if(threadPool)
                {
                    waitingQueueItem.m_threadPool = threadPool;
                    waitingQueueItem.m_threadPoolThreadIdx = hkAsyncThreadPool::getCurrentThreadIndex();
                }
                else
                {
                    waitingQueueItem.m_threadPoolThreadIdx = -1;
                    waitingQueueItem.m_semaphore = new hkSemaphore();
                }

                if(m_queueTail)
                {
                    m_queueTail->m_next = &waitingQueueItem;
                    m_queueTail = &waitingQueueItem;
                }
                else
                {
                    m_queueHead = m_queueTail = &waitingQueueItem;
                }

                m_queueLock.leave();

                if(waitingQueueItem.m_threadPoolThreadIdx >= 0)
                {
                    threadPool->acquireThreadSemaphore();
                }
                else
                {
                    waitingQueueItem.m_semaphore->acquire();
                    delete waitingQueueItem.m_semaphore;
                }

                break;
            }
            else
            {
                m_queueLock.leave();
            }
        }
    }
}

void hkAsyncThreadPoolMutex::leave()
{
    hkInt32 numContenders = m_numContenders.loadRelaxed();
    while(true)
    {
        if(numContenders == 1)
        {
            if(m_numContenders.compareAndSwap(numContenders, 0))
            {
                break;
            }
        }
        else
        {
            m_queueLock.enter();

            if(m_numContenders.compareAndSwap(numContenders, numContenders - 1))
            {
                HK_ASSERT(0x58d6e8a2, m_queueHead, "m_queueHead must be set when m_numContenders > 1.");

                WaitingQueueItem* queueHead = m_queueHead;
                if(queueHead->m_next)
                {
                    m_queueHead = queueHead->m_next;
                }
                else
                {
                    m_queueHead = m_queueTail = nullptr;
                }

                m_queueLock.leave();

                if(queueHead->m_threadPoolThreadIdx >= 0)
                {
                queueHead->m_threadPool->releaseThreadSemaphore(queueHead->m_threadPoolThreadIdx);
                }
                else
                {
                    queueHead->m_semaphore->release();
                }

                break;
            }
            else
            {
                m_queueLock.leave();
            }
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
