// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Object/hkReferencedObject.h>
#include <Common/Base/Container/Hash/hkHashMap.h>
#include <Common/Base/Thread/Async/hkRunningApproxMedian.h>

class HK_EXPORT_COMMON hkAsyncThreadPoolInstrumenter : public hkReferencedObject
{
public:
    hkAsyncThreadPoolInstrumenter();
    hkAsyncThreadPoolInstrumenter(hkArrayView<const hkAsyncThreadPoolInstrumenter*> instrumenters);

    void beginInstrument();
    void endInstrument();

    void newInterval(hkUint32 id);

    void getReport(hkStringBuf& res) const;

private:
    hkBool m_instrumenting;
    hkUint32 m_startId;
    hkUint64 m_startTime;

    typedef hkTuple<hkUint32, hkUint32> IntervalIDs;

    struct Interval
    {
        Interval()
            : m_numSamples(0)
        {
        }

        int m_numSamples;
        hkRunningApproxMedian<hkUint64> m_intervalTime;
    };

    hkHashMap<IntervalIDs, Interval> m_intervals;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
