// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Thread/Async/hkAsyncThreadPoolInstrumenter.h>
#include <Common/Base/System/Stopwatch/hkSystemClock.h>
#include <Common/Base/Algorithm/Sort/hkSort.h>

hkAsyncThreadPoolInstrumenter::hkAsyncThreadPoolInstrumenter()
{
    m_instrumenting = false;
}

hkAsyncThreadPoolInstrumenter::hkAsyncThreadPoolInstrumenter(hkArrayView<const hkAsyncThreadPoolInstrumenter*> instrumenters)
{
    m_instrumenting = false;

    for(const hkAsyncThreadPoolInstrumenter* instrumenter : instrumenters)
    {
        for(auto& pair : instrumenter->m_intervals.viewItems())
        {
            const IntervalIDs& intervalIDs = pair.m_0;
            const Interval& srcInterval = pair.m_1;

            auto it = m_intervals.findOrInsertKey(intervalIDs, Interval());
            Interval& destInterval = m_intervals.getValue(it);
            destInterval.m_numSamples += srcInterval.m_numSamples;
            destInterval.m_intervalTime.combine(srcInterval.m_intervalTime);
        }
    }
}

void hkAsyncThreadPoolInstrumenter::beginInstrument()
{
    m_instrumenting = true;
    m_startId = 0;
}

void hkAsyncThreadPoolInstrumenter::endInstrument()
{
    m_instrumenting = false;
}

void hkAsyncThreadPoolInstrumenter::newInterval(hkUint32 id)
{
    if(!m_instrumenting)
    {
        return;
    }

    hkUint64 curTime = hkSystemClock::getTickCounter();

    if(m_startId)
    {
        hkUint64 intervalTime = curTime - m_startTime;

        auto it = m_intervals.findOrInsertKey(hkTupleT::make(m_startId, id), Interval());
        Interval& interval = m_intervals.getValue(it);
        interval.m_numSamples++;
        interval.m_intervalTime.addSample(intervalTime);
    }

    m_startId = id;
    m_startTime = curTime;
}

void hkAsyncThreadPoolInstrumenter::getReport(hkStringBuf& res) const
{
    hkUint64 ticksPerSec = hkSystemClock::getTicksPerSecond();
    hkUint64 maxIntervalDuration = ticksPerSec / 10000;
    for(const auto& pair : m_intervals.viewItems())
    {
        const IntervalIDs& intervalIDs = pair.m_0;
        const Interval& interval = pair.m_1;

        hkUint64 mediansSum;
        int numMedians;
        interval.m_intervalTime.getMedian(mediansSum, numMedians);
        if(mediansSum > maxIntervalDuration * numMedians)
        {
            hkDouble64 timeMS = (hkDouble64)mediansSum * 1000.0 / (numMedians * ticksPerSec);
            res.appendFormat("Too long ({} ms, {} samples) between 0x{:x08} and 0x{:x08}.\n",
                timeMS, interval.m_numSamples, intervalIDs.m_0, intervalIDs.m_1);
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
