// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Thread/Async/hkAsyncThreadPoolDetail.h>

hkAsyncThreadPoolDetail::ToBackgroundQueue::ToBackgroundQueue(int numThreads)
{
    m_head = 0;
    m_tail.storeRelaxed(0);
    m_toBackground.setSize(numThreads);
    for(auto& toBackground : m_toBackground)
    {
        toBackground = -1;
    }

    m_numAllSemaphoresToBackground.storeRelaxed(0);
}

void hkAsyncThreadPoolDetail::ToBackgroundQueue::reset()
{
    // Sets the values in this ToBackgroundQueue back to their initial value.
    //
    // To reset the semaphore count, we have to determine the number of times
    // m_semaphore.release() has been called from the current state of the other
    // members, and call m_semaphore.acquire() a matching number of times.

    m_head = 0;
    m_tail.storeRelaxed(0);
    for(auto& toBackground : m_toBackground)
    {
        if(toBackground >= 0)
        {
            // A non negative entry in m_toBackground is a pending message,
            // which corresponds to a m_semaphore.release().
            m_semaphore.acquire();
        }

        toBackground = -1;
    }

    int numAllToBackground = m_numAllSemaphoresToBackground.swap(0);
    for(int i = 0; i < numAllToBackground; i++)
    {
        // Each increment of m_numAllSemaphoresToBackground corresponds to a
        // m_semaphore.release() call.
        m_semaphore.acquire();
    }
}

void hkAsyncThreadPoolDetail::ToBackgroundQueue::pushToBackground(int threadIdx)
{
    int tail = m_tail++;
    HK_ASSERT(0x4dacd16d, tail < m_toBackground.getSize(), "Capacity exceeded.");

    m_toBackground[tail] = threadIdx;

    m_semaphore.release();
}

void hkAsyncThreadPoolDetail::ToBackgroundQueue::pushAllSemaphoresToBackground()
{
    m_numAllSemaphoresToBackground++;

    m_semaphore.release();
}

        
hkAsyncThreadPoolDetail::ToBackgroundQueue::PopResult hkAsyncThreadPoolDetail::ToBackgroundQueue::pop()
{
    m_semaphore.acquire();

    int numAllSemaphoresToBackground = m_numAllSemaphoresToBackground.loadRelaxed();
    while(numAllSemaphoresToBackground)
    {
        if(m_numAllSemaphoresToBackground.compareAndSwap(numAllSemaphoresToBackground, numAllSemaphoresToBackground - 1))
        {
            return PopResult(-1);
        }
    }

    // If we get here, we know that there must be at least one element available
    // with an index into m_toBackground which lies in the range [m_head, m_tail).
    for(int i = m_head; true; i++)
    {
        if(m_toBackground[i] >= 0)
        {
            int threadIndex = m_toBackground[i];
            m_toBackground[i] = -2;

            while(m_head < m_toBackground.getSize() && 
                m_toBackground[m_head] == -2)
            {
                m_head++;
            }

            return PopResult(threadIndex);
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
