// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE hkAsyncHeartbeat::Heartbeat::Heartbeat(hkUint32 id)
    : m_heartbeatCounter(0)
{
#if HK_INSTRUMENT_HEARTBEAT
    m_instrumenter = Instrumenter::getCurrentInstrumenter();
#endif

    beat(id);
}

HK_INLINE void hkAsyncHeartbeat::Heartbeat::beginScope(hkUint32 id, HeartbeatFile file, const char* name)
{
#if HK_INSTRUMENT_HEARTBEAT
    if(m_instrumenter)
    {
        m_instrumenter->beginScope(id, file, name);
    }
#endif
}

HK_INLINE void hkAsyncHeartbeat::Heartbeat::endScope()
{
#if HK_INSTRUMENT_HEARTBEAT
    if(m_instrumenter)
    {
        m_instrumenter->endScope();
    }
#endif
}

template <hkUint32 id>
HK_INLINE void hkAsyncHeartbeat::Heartbeat::tick()
{
#if HK_INSTRUMENT_HEARTBEAT
    if(m_instrumenter)
    {
        m_instrumenter->endInterval(id);
        m_instrumenter->beginInterval();
        return;
    }
#endif

    m_heartbeatCounter += HeartbeatCount<id>::s_heartbeatCount;
    if(HK_VERY_UNLIKELY(m_heartbeatCounter < HeartbeatCount<id>::s_heartbeatCount))
    {
        beat(id);
    }
}

HK_INLINE void hkAsyncHeartbeat::Heartbeat::shortPath()
{
#if HK_INSTRUMENT_HEARTBEAT
    if(m_instrumenter)
    {
        m_instrumenter->invalidateInterval();
    }
#endif
}

template <hkUint32 id>
HK_INLINE int hkAsyncHeartbeat::Heartbeat::beginLoop()
{
#if HK_INSTRUMENT_HEARTBEAT
    if(m_instrumenter)
    {
        m_instrumenter->beginLoop();
        return HK_INT32_MAX;
    }
#endif

    m_heartbeatCounter += HeartbeatLoopCount<id>::s_startCount;
    if(HK_VERY_UNLIKELY(m_heartbeatCounter < HeartbeatLoopCount<id>::s_startCount))
    {
        beat(id);
    }

    return (0x40000000 / HeartbeatLoopCount<id>::s_iterationCount);
}

template <hkUint32 id>
HK_INLINE void hkAsyncHeartbeat::Heartbeat::endLoop()
{
#if HK_INSTRUMENT_HEARTBEAT
    if(m_instrumenter)
    {
        m_instrumenter->endLoop(id);
        m_instrumenter->beginInterval();
        return;
    }
#endif
}

template <hkUint32 id>
HK_INLINE void hkAsyncHeartbeat::Heartbeat::endLoop(int numIterations)
{
    loopTick<id>(numIterations);
    endLoop<id>();
}

template <hkUint32 id>
HK_INLINE void hkAsyncHeartbeat::Heartbeat::loopTick(int numIterations)
{
#if HK_INSTRUMENT_HEARTBEAT
    if(m_instrumenter)
    {
        m_instrumenter->loopTick(numIterations);
        return;
    }
#endif

    HK_WARN_ON_DEBUG_IF((hkUint64)numIterations * HeartbeatLoopCount<id>::s_iterationCount >= 0x100000000, 0x443173e8, "Too many iterations.");

    hkUint32 count = numIterations * HeartbeatLoopCount<id>::s_iterationCount;
    m_heartbeatCounter += count;
    if(HK_VERY_UNLIKELY(m_heartbeatCounter < count))
    {
        beat(id);
    }
}

template <hkUint32 id, typename FUNC>
HK_INLINE void hkAsyncHeartbeat::Heartbeat::forRange(int begin, int end, FUNC f)
{
    int numItsPerTick = beginLoop<id>();
    int i = begin;
    while(i != end)
    {
        int numIts = hkMath::min2(numItsPerTick, end - i);
        int curEnd = i + numIts;
        while(i < curEnd)
        {
            f(i);
            i++;
        }
        loopTick<id>(numIts);
    }
    endLoop<id>();
}

template <hkUint32 id>
HK_INLINE void hkAsyncHeartbeat::Heartbeat::forceHeartbeat()
{
#if HK_INSTRUMENT_HEARTBEAT
    if(m_instrumenter)
    {
        m_instrumenter->beginInterval();
        return;
    }
#endif

    m_heartbeatCounter = 0;
    beat(id);
}

template <hkUint32 id, typename FUNC>
HK_ALWAYS_INLINE void hkAsyncHeartbeat::NullHeartbeat::forRange(int begin, int end, FUNC f)
{
    for(int i = begin; i < end; i++)
    {
        f(i);
    }
}

HK_INLINE hkAsyncHeartbeat::Scope::Scope(Heartbeat& heartbeat, hkUint32 id, HeartbeatFile file, const char* name)
{
#if HK_INSTRUMENT_HEARTBEAT
    m_heartbeat = &heartbeat;
    heartbeat.beginScope(id, file, name);
#endif
}

HK_INLINE hkAsyncHeartbeat::Scope::Scope(hkAsyncHeartbeat::NullHeartbeat& heartbeat, hkUint32 id, HeartbeatFile file, const char* name)
{
#if HK_INSTRUMENT_HEARTBEAT
    m_heartbeat = nullptr;
#endif
}

#if HK_INSTRUMENT_HEARTBEAT
HK_INLINE hkAsyncHeartbeat::Scope::~Scope()
{
    if(m_heartbeat)
    {
        m_heartbeat->endScope();
    }
}
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
