// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/System/hkBaseSystem.h>

// The head of the list for this DLL, which gets added to the registry singleton
hkBaseSystem::InitNode* hkBaseSystem::InitNode::s_listHead;
bool hkBaseSystem::InitNode::s_initCalled;

void hkBaseSystem::InitNode::internalConstruct(_In_z_ const char* name, VoidFuncPtr initfunc, VoidFuncPtr quitfunc, _Inout_opt_ void* arg, bool reg)
{
    m_name = name;
    m_initFunction = initfunc;
    m_quitFunction = quitfunc;
    m_arg = arg;
    m_next = HK_NULL;
    if (reg)
    {
        HK_ASSERT(0x2f26031f, !s_initCalled, "Can't construct after the static initialization in excutables and dynamic libraries.");
        m_next = s_listHead;
        s_listHead = this;
    }
}

hkBaseSystem::InitList::InitList(_In_z_ const char* name)
    : InitNode(name, &hkBaseSystem::initNodes, &hkBaseSystem::quitNodes, &hkBaseSystem::InitNode::s_listHead, false)
{
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
