// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

/// An error report function to be passed to Havok when initializing it subsystems. In particular
typedef void (HK_CALL *hkErrorReportFunction)(_In_z_ const char* s, _Inout_opt_ void* errorReportObject);

class hkMemoryRouter;

namespace hkKeyCode
{
    enum KeycodeType
    {
        EVALUATION,
        CLIENT
    };

    struct KeyCodeInfo
    {
       const char* keycode;
       hkLong daysUntilExpired;

       hkStringView expirationDate;
       hkStringView product;
       hkStringView identifier;

       KeycodeType keycodeType;
    };

    /// This can be used to initialize your static arrays for getting keycode info
    /// since there should never be more than than this many keycodes.
    static const int MAX_KEYCODES = 10;

        /// Fill out array of ref KeyCodeInfo structures
        /// \returns Total number of keycodes written out
    HK_EXPORT_COMMON hkInt32 HK_CALL getKeyCodeInfo(KeyCodeInfo* outKeyCodeInfo, hkInt32 maxInfo);
}

/// This class is used to initialize the Havok subsystems (memory, singleton, etc).
namespace hkBaseSystem
{
        /// Initializes Havok's subsystems.
        /// Havok provides a number of memory systems, please consult hkMemoryInitUtil for more details.
        /// On error, the errorReportFunction is called with an error string and the errorReportObject pointer.
        /// init() sets in internal flag, so it may be called more than once but multiple init() and quit() calls
        /// do not nest.
        /// After initialization, the ErrorReport singleton contains the supplied error function and object.
    HK_EXPORT_COMMON hkResult HK_CALL init(
        _In_ hkMemoryRouter* memoryRouter,
        _In_opt_ hkErrorReportFunction errorReportFunction,
        _Inout_opt_ void* errorReportObject = HK_NULL );

        /// Call for each active thread, sets the thread local router variable.
    HK_EXPORT_COMMON hkResult HK_CALL initThread( _In_ hkMemoryRouter* threadAllocator );
        ///
    HK_EXPORT_COMMON hkResult HK_CALL quitThread();

        /// Quit the subsystems. It is safe to call multiple times.
        /// It cleans up in reverse order to init: default singletons, hkError,
        /// hkFileSystem and hkMemory
    HK_EXPORT_COMMON hkResult HK_CALL quit();

        /// Checks if the system has already been initialized.
    HK_EXPORT_COMMON hkBool HK_CALL isInitialized();

        /// Calls the error report function given to hkBaseBystem::init.
    HK_EXPORT_COMMON void HK_CALL error(_In_z_ const char* s, _Inout_opt_ void* unused=HK_NULL);

        /// Structure used to hook hkBaseSystem startup and shutdown.
        /// The pattern is: create a static instances of InitNode. The default constructor will
        /// place the instance into an intrusive linked list. During hkBaseSystem::init/quit, the init/quit
        /// function (if supplied to the constructor) will be called.
        ///
        /// This is the mechanism used to create singletons at startup, but is also used by other systems.
        /// An optional argument may be supplied (e.g. for singleton this is the address of the pointer to hold the singleton)
        ///
        /// Because the order of static constructors is unspecified, the order of InitNodes in the static list is unspecified.
        /// If an init function cannot run (e.g. because it depends on another not-yet-initialized InitNode), it may return
        /// a failure hkResult from its init function.
        /// Thus hkBaseSystem::init may loop over the list several times.
    struct InitNode
    {
        HK_DECLARE_PLACEMENT_ALLOCATOR();

        template<typename T>
        struct FuncPtr
        {
            typedef hkResult(HK_CALL *Type)(T* arg);
        };
        typedef FuncPtr<void>::Type VoidFuncPtr;

        InitNode(_In_z_ const char* name, VoidFuncPtr finit, VoidFuncPtr fquit, _Inout_opt_ void* arg = HK_NULL, bool reg = true)
        {
            internalConstruct(name, finit, fquit, arg, reg);
        }

        template<typename T>
        InitNode(_In_z_ const char* name, typename FuncPtr<T>::Type finit, typename FuncPtr<T>::Type fquit, _Inout_opt_ T* arg = HK_NULL, bool reg = true)
        {
            internalConstruct(name, reinterpret_cast<VoidFuncPtr>(finit), reinterpret_cast<VoidFuncPtr>(fquit), arg, reg);
        }

            // Internal construction - this would normally be protected except that the codegen for non-POD statics is bad.
        void internalConstruct(_In_z_ const char* name, VoidFuncPtr finit, VoidFuncPtr fquit, _Inout_opt_ void* arg, bool reg);

            /// Initialize this node
        HK_EXPORT_COMMON hkResult init() const;
            /// Quit this node
        HK_EXPORT_COMMON hkResult quit() const;

            // These members should be considered private

        const char* m_name;
        VoidFuncPtr m_initFunction;
        VoidFuncPtr m_quitFunction;
        void* m_arg;

        InitNode* m_next;
        static InitNode* s_listHead;
        static bool s_initCalled;
    };

        /// Wraps the list of all InitNodes in a module. Init and quit functions are respectively
        /// hkBaseSystem::initNodes and hkBaseSystem::quitNodes.
    struct InitList : public InitNode
    {
        HK_DECLARE_PLACEMENT_ALLOCATOR();
        InitList(_In_z_ const char* name);
    };

        /// Utility function to initialize the registered hkSystemInitQuitEntries, called from init().
        /// You do not need to call this method unless you have completely replaced
        /// the init method or you are loading a DLL which contains entries.
    HK_EXPORT_COMMON hkResult HK_CALL initNodes(_Inout_ InitNode** addrHead);

        /// Utility function to quit the registered hkSystemInitQuitEntries, called from quit().
        /// You do not need to call this method unless you have completely replaced
        /// the quit method or you are unloading a DLL which contains entries.
    HK_EXPORT_COMMON hkResult HK_CALL quitNodes(_Inout_ InitNode** addrHead);

        /// Add a single node to an internal list.
        /// The nodes init function will be called during hkBaseSystem::init and the quit function
        /// during hkBaseSystem::quit.
    HK_EXPORT_COMMON void HK_CALL registerInitList(_Inout_ InitList*);
        /// Remove the node from the registered list.
    HK_EXPORT_COMMON void HK_CALL unregisterInitList(_Inout_ InitList*);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
