// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>

#if defined(HK_PLATFORM_NX) && !defined(HK_PLATFORM_NX_WIN32) && !defined(HK_PLATFORM_NX_X64)
#   include <nn/time/time_Api.h>
#   include <nn/time/time_StandardNetworkSystemClock.h>
#   include <nn/time/time_StandardUserSystemClock.h>
#if defined (HK_NINTENDO_MIDDLEWARE)
#    ifdef HK_PLATFORM_NX
#        include <nn/nn_Middleware.h>
#    else
#        include <nn/middleware.h>  
#    endif
#    define HK_NINTENDO_MODULE_NAME "Havok"
#    define HK_NINTENDO_MODULE_VERSION "2017_2"
#    if defined(HK_DEBUG_SLOW)
#        define HK_NINTENDO_CONFIG_SUFFIX "-Debug"
#    elif defined(HK_DEBUG)
#        define HK_NINTENDO_CONFIG_SUFFIX "-Develop"
#    else
#        define HK_NINTENDO_CONFIG_SUFFIX
#    endif
NN_DEFINE_MIDDLEWARE(hkNintendoModuleInfo, "Microsoft", HK_NINTENDO_MODULE_NAME "-" HK_NINTENDO_MODULE_VERSION HK_NINTENDO_CONFIG_SUFFIX);
#endif
#endif

#if defined(HK_PLATFORM_WIIU) && defined(HK_NINTENDO_MIDDLEWARE)
#   include <nn/middleware.h>  
NN_DEFINE_MIDDLEWARE( hkWiiuModuleInfo, "Havok", "hk_2017_1" );
#endif


// Provides date and time functions usually found in libc
extern "C"
{
    // Returns the number of seconds since 1970.
    HK_EXPORT_COMMON hkSystemTime hkGetSystemTime();

    //
    // Special Implementations
    //

#if defined(HK_PLATFORM_WIIU)

    #include <cafe.h>
    #include <cafe/os.h>

    hkSystemTime hkGetSystemTime()
    {
#if defined (HK_NINTENDO_MIDDLEWARE)
        NN_USING_MIDDLEWARE( hkWiiuModuleInfo );
#endif

        OSTime secs = OSTicksToSeconds(OSGetTime()) + 946684800; // secs from 1970

        return static_cast<hkSystemTime>(secs);
    }

#elif defined(HK_PLATFORM_CTR)

    #include <nn/fnd.h>

    hkSystemTime hkGetSystemTime()
    {
        nn::fnd::TimeSpan diffDate = nn::fnd::DateTime::GetNow() - nn::fnd::DateTime(1970, 1, 1);
        return static_cast<hkSystemTime>(diffDate.GetSeconds());
    }

#elif defined(HK_PLATFORM_NX) && !defined(HK_PLATFORM_NX_WIN32) && !defined(HK_PLATFORM_NX_X64)

    hkSystemTime hkGetSystemTime()
    {
#if defined (HK_NINTENDO_MIDDLEWARE)
        NN_USING_MIDDLEWARE( hkNintendoModuleInfo );
#endif
        if( !nn::time::IsInitialized() )
        {
            nn::time::Initialize();
        }

        nn::time::PosixTime network_time;
        nn::Result network_result = nn::time::StandardNetworkSystemClock::GetCurrentTime( &network_time );
        nn::time::PosixTime user_time;
        nn::Result user_result = nn::time::StandardUserSystemClock::GetCurrentTime( &user_time );

        if( network_result.IsSuccess() )
        {
            if( user_result.IsSuccess() )
            {
                return HK_MAX2( network_time.value, user_time.value );
            }
            return network_time.value;
        }
        return user_time.value;
    }

#else

    //
    // LIBC Implementation
    //

    #include <time.h>

    HK_EXPORT_COMMON hkSystemTime hkGetSystemTime()
    {
        return static_cast<hkSystemTime>( ::time(0) );
    }

#endif
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
