// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/System/Stopwatch/hkSystemDate.h>
#include <Common/Base/System/Stopwatch/hkSystemTime.h>

HK_EXPORT_COMMON void HK_CALL hkSystemDate::getStringDate( hkStringBuf& outDateStr )
{
    // seconds since 1970
    hkSystemTime ltime = hkGetSystemTime();

    // remove hours, minutes and seconds
    ltime = ltime - (ltime % (24 * 3600));

    hkLong timeDays = hkLong( ltime / (24 * 3600) );
    hkLong dummyYear = 1970;
    hkLong dummyDays = 0;
    hkInt32 timeYear = 1970;
    hkInt32 timeMonth = 0;
    hkInt32 days[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
    hkInt32 yearLength;

    // calculate correct year
    for( hkLong i = timeDays; i > 0; dummyYear++ )
    {
        // if leap year
        ((!(dummyYear % 4) && (dummyYear % 100)) || !(dummyYear % 400)) ? yearLength = 366 : yearLength = 365;
        if( i < yearLength )
        {
            // add 1 because this is only counting full days
            dummyDays = i + 1;
            break;
        }
        else
        {
            i -= yearLength;
            timeYear++;
        }
    }
    // if year is leap year increase days in Febuary to 29
    ((!(timeYear % 4) && (timeYear % 100)) || !(timeYear % 400)) ? days[1]++ : days[1];

    // calculate months and days
    for( hkInt32 i = 0; i < (hkInt32)(sizeof( days ) / sizeof( hkInt32 )); i++ )
    {
        if( dummyDays <= days[i] )
        {
            timeDays = dummyDays;
            timeMonth++;
            // if is start of month
            (timeDays == 0) ? timeDays = 1 : timeDays;
            break;
        }
        dummyDays -= days[i];
        timeMonth++;
    }

    outDateStr.format( "{}-{}-{}", (int)timeYear, (int)timeMonth, (int)timeDays );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
