// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/System/Stopwatch/hkSystemClock.h>

#if defined(HK_PLATFORM_WIN32)
#   include <Common/Base/System/Stopwatch/Impl/hkWindowsSystemClock.h>

#elif defined(HK_PLATFORM_LINUX)
#   include <Common/Base/System/Stopwatch/Impl/hkLinuxSystemClock.h>

#elif defined(HK_PLATFORM_MAC) || defined(HK_PLATFORM_IOS)
#   include <Common/Base/System/Stopwatch/Impl/hkMacSystemClock.h>

#elif defined(HK_PLATFORM_WIIU)
#   include <Common/Base/System/Stopwatch/Impl/hkWiiuSystemClock.h>

#elif defined(HK_PLATFORM_PSVITA)
#   include <Common/Base/System/Stopwatch/Impl/hkPsVitaSystemClock.h>

#elif defined(HK_PLATFORM_LRB)
#   include <Common/Base/System/Stopwatch/Impl/hkLrbSystemClock.h>

#elif defined(HK_PLATFORM_CTR)
#   include <Common/Base/System/Stopwatch/Impl/hkCtrSystemClock.h>

#elif defined(HK_PLATFORM_ANDROID) || defined(HK_PLATFORM_TIZEN)
#   include <Common/Base/System/Stopwatch/Impl/hkAndroidSystemClock.h>

#elif defined(HK_PLATFORM_PS4)
#   include <Common/Base/System/Stopwatch/Impl/hkPs4SystemClock.h>

#elif defined(HK_PLATFORM_NX)
#   include <Common/Base/System/Stopwatch/Impl/hkNxSystemClock.h>

#else
#  error ERROR: No SystemClock implementation available!

#endif

namespace
{
    HK_INLINE hkReal divide64( hkUint64 a, hkUint64 b )
    {
        return hkReal( double( hkInt64( a ) ) / double( hkInt64( b ) ) );
    }
}

hkReal HK_CALL hkSystemClock::secondsFromTicks( hkUint64 tickDelta )
{
    return divide64( tickDelta, hkSystemClock::getTicksPerSecond() );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
