
// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 DURANGO METRO_X86 METRO_X64 METRO_ARM APOLLO_X86 APOLLO_ARM !REFLECT UWP_X86 UWP_X64 UWP_ARM
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#if defined(HK_PLATFORM_WIN32)
#   include <Common/Base/Fwd/hkwindows.h>
#else
#   error wrong include
#endif

hkUint64 HK_CALL hkSystemClock::getTickCounter()
{
    hkUint64 ticks;
#if defined(HK_ARCH_X64)
    // Using intrinsics for AMD64 until the compiler supports __asm
    ticks = __rdtsc();
#elif defined(HK_ARCH_IA32)
    // note: using cpuid as a serializing makes timings more accurate,
    // at the expense of more overhead. (1.5% without versus 5% with cpuid)
    __asm {
        pushad
        cpuid
        rdtsc
        mov dword ptr[ticks  ], eax
        mov dword ptr[ticks+4], edx
        popad
    }
#elif defined(HK_ARCH_ARM)
    //unsigned int value;
    // Read CCNT Register
    //__asm volatile ("MRC p15, 0, %0, c9, c13, 0\t\n": "=r"(value));
    LARGE_INTEGER i;
    QueryPerformanceCounter(&i);
    ticks = i.QuadPart;
#elif defined(HK_ARCH_PPC)
    ticks = __mftb();
#endif

    return ticks;
}

hkUint64 HK_CALL hkSystemClock::getTicksPerSecond()
{
    static hkUint64 freq = 0;
    if(freq==0)
    {
        hkUint64 ticks;
        hkUint64 qticks;
        hkUint64 ticks2;
        hkUint64 qticks2;
        double avgFactor = 0;
        const int numIters = 100;

        // Iterate several times
        for (int iter = 0; iter < numIters; iter++)
        {
            ticks = getTickCounter();
            QueryPerformanceCounter( (LARGE_INTEGER*) &qticks);

            ///
            /// Sleep for a little while
            ///
            volatile int x=1;
            for (int j=0; j< 50000; j++)
            {
                x += x*x;
            }


            ticks2 = getTickCounter();
            QueryPerformanceCounter( (LARGE_INTEGER*) &qticks2);

            // We assume that this is fixed & regular
            QueryPerformanceFrequency( (LARGE_INTEGER*) &freq);

            // Work our calibration factor
            hkUint64 diff = ticks2 - ticks;
            hkUint64 qdiff = qticks2 - qticks;

            double factor = double(diff)/ double(qdiff);

            avgFactor += factor;
            }

        avgFactor /= numIters;
        freq = hkUint64(avgFactor * freq);
    }
    return freq;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
