// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/System/StackTracer/hkStackTracer.h>

hkStackTracer::hkStackTracer()
{
}

hkStackTracer::~hkStackTracer()
{
}

void hkStackTracer::dumpStackTrace(_In_reads_(numtrace) const hkUlong* trace, int numtrace, printFunc pfunc, _Inout_opt_ void* context) const
{
    for( int i = 0; i < numtrace; ++i )
    {
        char buf[256];
        hkString::snprintf(buf, sizeof(buf), "0x%x\n", trace[i] );
        pfunc(buf, context);
    }
}

int hkStackTracer::getStackTrace(_Out_writes_(maxtrace) hkUlong* trace, int maxtrace, int framesToSkip, _Inout_opt_ void* origin)
{
#if defined(HK_PLATFORM_ANDROID) && !defined(HK_DEBUG_SLOW)
    // On Dev with Android x86 this doesn't work due to compiler optimizations.
    return 0;

#else
    struct frame
    {
        frame* next;
        hkUlong retaddr;
    };

    frame* stackPtr;
    frame* framePtr;

#   if defined(HK_COMPILER_GCC) || defined(HK_COMPILER_CLANG)
    __asm__ __volatile__ (  "movl %%esp, %0\n"
                            "movl %%ebp, %1"
                          :"=r"(stackPtr), "=r"(framePtr)
                          :
                          :);
#   else
    __asm
    {
#       ifdef HK_ARCH_X64
            mov stackPtr, rsp
            mov framePtr, rbp
#       else
            mov stackPtr, esp
            mov framePtr, ebp
#       endif
    }
#   endif
    int numFrames = 0;
    if( stackPtr && framePtr )
    {
        frame* current = framePtr;

        while ( framesToSkip-- > 0
            && (stackPtr < current)
            && (current != 0)
            && (current->retaddr != 0) )
        {
            current = current->next;
        }

        while( (numFrames < maxtrace)
            && (stackPtr < current)
            && (current != 0)
            && (current->retaddr != 0) )
        {
            trace[numFrames++] = current->retaddr;
            current = current->next;
        }
    }

    if( framesToSkip )
    {
        numFrames = hkMath::max2( numFrames-framesToSkip, 0 );
        for(int i = 0; i < numFrames; i++)
        {
            trace[i] = trace[i+framesToSkip];
        }
    }

    return numFrames;
#endif
}

void hkStackTracer::refreshSymbols(_In_opt_z_ const char* dllFile)
{
}

void hkStackTracer::getModuleInfo( printFunc pfunc, _Inout_opt_ void* context ) const
{
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
