// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#if defined(HK_PLATFORM_LINUX)
#   include <Common/Base/Fwd/hkcmalloc.h>
#   include <Common/Base/Fwd/hkcstdio.h>
#   include <Common/Base/Fwd/hkcstring.h>
#   include <execinfo.h>
#   include <cxxabi.h>
#   define backtrace_symbols_free(syms) free(syms)
#else
#   error "Dont know where to find 'backtrace'"
#endif

//
// Be careful not to call any havok functions which may
// result in a memory allocation as these methods are
// called from the debug memory destructor
//

hkStackTracer::hkStackTracer()
{
}

hkStackTracer::~hkStackTracer()
{
}

static const int IGNORE_FRAMES = 2;

#if 0 // Slow backtrace from gdb

extern char* program_invocation_name;

// This is slow compared to simply calling backtrace_symbols, but gives it
// gives the file:line information.
void hkStackTracer::dumpStackTrace(_In_reads_(numtrace) const hkUlong* trace, int numtrace, printFunc pfunc, _Inout_opt_ void* context) const
{
    char cmd[1024];
    int cur = snprintf( cmd, sizeof(cmd), "addr2line -C -f -e %s", program_invocation_name);
    for( int i = IGNORE_FRAMES; i < numtrace; ++i )
    {
        cur += snprintf( cmd+cur, sizeof(cmd)-cur, " %p", (void*)trace[i] );
        if( cur > (int)sizeof(cmd) ) return;
    }
    FILE* fin = popen(cmd, "r");
    while( feof(fin) == 0 )
    {
        char func[1024];
        char file[1024];
        if( fgets(func, sizeof(func), fin) )
        {
            if( fgets(file, sizeof(file), fin) )
            {
                int l = strlen(file);
                file[ l > 0 ? l-1 : 0 ] = 0;
                pfunc(file, context);
                pfunc(":", context);
                pfunc(func, context);
            }
        }
    }
    pclose(fin);
}

#else

void hkStackTracer::dumpStackTrace(_In_reads_(numtrace) const hkUlong* trace, int numtrace, printFunc pfunc, _Inout_opt_ void* context) const
{

    char** strings = backtrace_symbols( (void* const*)trace, numtrace);
    if(strings)
    {
        for( int i = IGNORE_FRAMES; i < numtrace; ++i )
        {
            const char* loc = hkString::strChr(strings[i], '(');
            char outputBuf[1024];

            if(!loc)
            {
                hkString::snprintf(outputBuf, sizeof(outputBuf), "%s\n", strings[i]);
            }
            else
            {
                //The string returned from backtrace_symbols looks like:
                // /path/to/exeutable(mangledFunctionName+0xOFFSET) [0xADDRESS]
                //We want to display:
                //[0xADDRESS] (demangledName)
                int addressStart = hkString::lastIndexOf(loc, '[');

                char functionName[1024];
#ifdef HK_PLATFORM_LINUX
                int demangleFailed = 1;
                char* demangledName = HK_NULL;
                {
                    int functionNameEnd = hkString::indexOf(loc, '+');
                    if(functionNameEnd != -1 && functionNameEnd < int(sizeof(functionName)) - 1)
                    {
                        //Temporarily use the outputBuf to store the mangled symbol name
                        hkString::memCpy(outputBuf, loc + 1, functionNameEnd - 1);
                        outputBuf[functionNameEnd - 1] = 0;
                        demangledName = abi::__cxa_demangle(outputBuf, HK_NULL, HK_NULL, &demangleFailed);
                    }
                }

                if(!demangleFailed)
                {
                    hkString::strNcpy(functionName, demangledName, sizeof(functionName));
                    free(demangledName);
                }
                else
#endif
                {
                    int locEnd = hkMath::min2(hkString::lastIndexOf(loc, ')') + 1, sizeof(functionName) - 1);
                    hkString::strNcpy(functionName, loc, locEnd);
                    functionName[locEnd] = 0;
                }


                hkString::snprintf(outputBuf, sizeof(outputBuf), "%s %s\n", loc + addressStart, functionName);
            }

            pfunc(outputBuf, context);
        }
        backtrace_symbols_free(strings);
    }
    else
    {
        char buf[100];
        for( int i = IGNORE_FRAMES; i < numtrace; ++i )
        {
            hkString::snprintf(buf, sizeof(buf), "%.8x (no symbols)\n", trace[i]);
            pfunc(buf, context);
        }
    }
}

#endif

int hkStackTracer::getStackTrace(_Out_writes_(maxtrace) hkUlong* trace, int maxtrace, int framesToSkip, _Inout_opt_ void* origin)
{
    int depth = backtrace( (void**)trace, maxtrace+framesToSkip);
    int numFrames = hkMath::max2( depth-framesToSkip, 0 );

#ifdef HK_PLATFORM_PSP
    extern char _etext[];

    for(int i = 0; i < numFrames; i++)
    {
        trace[i] = ((char*)trace[i+framesToSkip] - _etext);
    }
#else
    if( framesToSkip )
    {
        for(int i = 0; i < numFrames; i++)
        {
            trace[i] = trace[i+framesToSkip];
        }
    }
#endif
    return numFrames;
}

void hkStackTracer::refreshSymbols(_In_opt_z_ const char* dllFile)
{
}

void hkStackTracer::getModuleInfo(printFunc pfunc, _Inout_opt_ void* context) const
{
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
