// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// Operating System
#if defined(HK_PLATFORM_WIN32)
#   if defined(HK_PLATFORM_DURANGO)
#       define HK_OPERATING_SYSTEM_STRING "XboxOne"
#   else
#       define HK_OPERATING_SYSTEM_STRING "Win"
#   endif
#elif defined(HK_PLATFORM_PS4)
#   define HK_OPERATING_SYSTEM_STRING "PS4"
#elif defined(HK_PLATFORM_TVOS)
#   define HK_OPERATING_SYSTEM_STRING "tvOS"
#elif defined(HK_PLATFORM_MAC)
#   define HK_OPERATING_SYSTEM_STRING "macOS"
#elif defined(HK_PLATFORM_IOS)
#   define HK_OPERATING_SYSTEM_STRING "iOS"
#elif defined(HK_PLATFORM_ANDROID)
#   define HK_OPERATING_SYSTEM_STRING "Android"
#elif defined(HK_PLATFORM_TIZEN)
#   define HK_OPERATING_SYSTEM_STRING "Tizen"
#elif defined(HK_PLATFORM_LINUX)
#   if defined(HK_PLATFORM_NACL)
#       define HK_OPERATING_SYSTEM_STRING "NaCl"
#   else
#       define HK_OPERATING_SYSTEM_STRING "Linux"
#   endif
#elif defined(HK_PLATFORM_WIIU)
#   define HK_OPERATING_SYSTEM_STRING "WiiU"
#elif defined(HK_PLATFORM_CTR)
#   define HK_OPERATING_SYSTEM_STRING "3DS"
#elif defined(HK_PLATFORM_PSVITA)
#   define HK_OPERATING_SYSTEM_STRING "PS_Vita"
#elif defined(HK_PLATFORM_NX)
#   define HK_OPERATING_SYSTEM_STRING "NX"
#else
#   error Could not autodetect operating system.
#endif

// Arch
#if defined(HK_ARCH_INTEL)
#   define HK_ARCH_FAMILY_STRING "Intel_"
#elif defined(HK_ARCH_PPC)
#   define HK_ARCH_FAMILY_STRING "PPC_"
#elif defined(HK_ARCH_ARM)
#   define HK_ARCH_FAMILY_STRING "Arm_"
#else
#   error Could not autodetect architecture family.
#endif
#if (HK_POINTER_SIZE == 8)
#   define HK_ARCH_BITS_STRING "64"
#else
#   define HK_ARCH_BITS_STRING "32"
#endif
#define HK_ARCH_STRING HK_ARCH_FAMILY_STRING HK_ARCH_BITS_STRING

// Compiler
#if defined(HK_COMPILER_INTEL)
#   define HK_COMPILER_FAMILY_STRING "Intel"
#   define HK_COMPILER_VERSION HK_COMPILER_INTEL_VERSION
#elif defined(HK_COMPILER_CLANG)
#   define HK_COMPILER_FAMILY_STRING "Clang"
#   define HK_COMPILER_VERSION __clang_version__
#elif defined(HK_COMPILER_SNC)
#   define HK_COMPILER_FAMILY_STRING "SNC"
#   if defined(HK_PLATFORM_PSVITA)
#       define HK_COMPILER_VERSION __SN_FULL_VER__
#   else
#       define HK_COMPILER_VERSION HK_COMPILER_GCC_VERSION
#   endif
#elif defined(HK_COMPILER_ARMCC)
#   define HK_COMPILER_FAMILY_STRING "Arm"
#   define HK_COMPILER_VERSION HK_COMPILER_GCC_VERSION
#elif defined(HK_COMPILER_GHS)
#   define HK_COMPILER_FAMILY_STRING "GHS"
//# define HK_COMPILER_VERSION __GHS_VERSION_NUMBER
#   define HK_COMPILER_VERSION HK_COMPILER_GCC_VERSION
#elif defined(HK_COMPILER_GCC)
#   define HK_COMPILER_FAMILY_STRING "GCC"
#   define HK_COMPILER_VERSION HK_COMPILER_GCC_VERSION
#elif defined(HK_COMPILER_MSVC)
#   define HK_COMPILER_FAMILY_STRING "MSVC"
#   define HK_COMPILER_VERSION HK_COMPILER_MSVC_VERSION
#else
#   error Could not autodetect compiler.
#endif
#define HK_COMPILER_VERSION_STRING HK_PP_STRINGIFY_VALUE( HK_COMPILER_VERSION )
#define HK_COMPILER_STRING HK_COMPILER_FAMILY_STRING ":" HK_COMPILER_VERSION_STRING

// Platform
#if defined(HK_PLATFORM_DURANGO) || defined(HK_PLATFORM_PS4) || defined(HK_PLATFORM_WIIU) || \
        defined(HK_PLATFORM_CTR) || defined(HK_PLATFORM_PSVITA)
// No distinctions
#   define HK_PLATFORM_STRING HK_OPERATING_SYSTEM_STRING
#elif defined(HK_PLATFORM_NX)
// With arch distinction
#   define HK_PLATFORM_STRING HK_OPERATING_SYSTEM_STRING "_" HK_ARCH_STRING
#elif defined(HK_PLATFORM_WIN32) || defined(HK_PLATFORM_MAC) || defined(HK_PLATFORM_LINUX) || \
        defined(HK_PLATFORM_IOS) || defined(HK_PLATFORM_TVOS) || defined(HK_PLATFORM_ANDROID) || \
        defined(HK_PLATFORM_TIZEN)
// With category and arch distinction
#   if defined(HK_PLATFORM_UWP)
#       define HK_PLATFORM_CATEGORY_STRING "UWP_"
#   elif defined(HK_PLATFORM_METRO)
#       define HK_PLATFORM_CATEGORY_STRING "Metro_"
#   else
#       define HK_PLATFORM_CATEGORY_STRING ""
#   endif
#   if defined(HK_PLATFORM_WINRT)
#       define HK_PLATFORM_RUNTIME_STRING "WinRT_"
#   elif defined(HK_PLATFORM_WIN32)
#       define HK_PLATFORM_RUNTIME_STRING "WinAPI_"
#   elif defined(HK_PLATFORM_MAC)
#       define HK_PLATFORM_RUNTIME_STRING "Mac_"
#   elif defined(HK_PLATFORM_LINUX)
#       if defined(HK_PLATFORM_NACL)
#           define HK_PLATFORM_RUNTIME_STRING "NaCl_"
#       else
#           define HK_PLATFORM_RUNTIME_STRING "Linux_"
#       endif
#   elif defined(HK_PLATFORM_IOS)
#       define HK_PLATFORM_RUNTIME_STRING "iOS_"
#   elif defined(HK_PLATFORM_TVOS)
#       define HK_PLATFORM_RUNTIME_STRING "tvOS_"
#   elif defined(HK_PLATFORM_ANDROID)
#       define HK_PLATFORM_RUNTIME_STRING "Android_"
#   elif defined(HK_PLATFORM_TIZEN)
#       define HK_PLATFORM_RUNTIME_STRING "Tizen_"
#   else
#   error Could not autodetect runtime.
#   endif
#   define HK_PLATFORM_STRING HK_PLATFORM_CATEGORY_STRING HK_PLATFORM_RUNTIME_STRING HK_ARCH_STRING
#else
#   error Could not autodetect platform.
#endif

// SIMD
#if defined(HK_PLATFORM_WIN32)
#   if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
#       if (HK_SSE_VERSION >= 0x51)
#           define HK_SIMD_STRING "AVX_FMA"
#       elif (HK_SSE_VERSION >= 0x50)
#           define HK_SIMD_STRING "AVX"
#       elif (HK_SSE_VERSION >= 0x42)
#           define HK_SIMD_STRING "SSE_4_2"
#       elif (HK_SSE_VERSION >= 0x41)
#           define HK_SIMD_STRING "SSE_4_1"
#       elif (HK_SSE_VERSION >= 0x40)
#           define HK_SIMD_STRING "SSE_4_AES"
#       elif (HK_SSE_VERSION >= 0x31)
#           define HK_SIMD_STRING "SSSE_3"
#       elif (HK_SSE_VERSION >= 0x30)
#           define HK_SIMD_STRING "SSE_3"
#       else
#           define HK_SIMD_STRING "SSE_2"
#       endif
#   else
#       define HK_SIMD_STRING "FPU"
#   endif
#else
#   if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
#       define HK_SIMD_STRING "SIMD"
#   else
#       define HK_SIMD_STRING "nonSIMD"
#   endif
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
