// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

/// Platform information.
/// This is mostly a presentation of compile-time information in human-readable form.
/// The strings returned here should not be the source for important platform-dependent code
/// branching.  It's intended to provide a human-recognizable name for the computing platform.
/// For conditional code compilation use HK_PLATFORM_, HK_ARCH_, and other hkBaseDef defines.
namespace hkPlatformInfo
{
    /// Get a human-recognizable name for the computing platform.
    /// Use HK_PLATFORM_, HK_ARCH_, and other hkBaseDef defines for platform-conditional code.
    HK_EXPORT_COMMON const char* HK_CALL getPlatformName();

    /// Get a human-recognizable name for the computing operating system.
    /// Use HK_PLATFORM_, HK_ARCH_, and other hkBaseDef defines for os-conditional code.
    HK_EXPORT_COMMON const char* HK_CALL getOperatingSystemName();

    /// Get a human-recognizable name for the hardware's architecture.
    /// Use HK_PLATFORM_, HK_ARCH_, and other hkBaseDef defines for architecture-conditional code.
    HK_EXPORT_COMMON const char* HK_CALL getArchitectureName();

    /// Get a name for the specific device if available (Eg. pc name).
    HK_EXPORT_COMMON const char* HK_CALL getDeviceName( hkStringPtr& nameOut );

    /// Get a human-recognizable name for the hardware's simd support.
    /// Use HK_PLATFORM_, HK_ARCH_, other hkBaseDef defines, and hkHardwareInfo features for simd-conditional code.
    HK_EXPORT_COMMON const char* HK_CALL getSimdSupportString();

    /// Get a human-recognizable name for the compiler.
    /// Use HK_PLATFORM_, HK_ARCH_, and other hkBaseDef defines for compiler-conditional code.
    HK_EXPORT_COMMON const char* HK_CALL getCompilerName();
};

#include <Common/Base/System/Platform/hkPlatformInfo.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
