// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/System/Platform/hkPlatformInfo.h>
#include <Common/Base/System/Hardware/hkHardwareInfo.h>

#if defined(HK_PLATFORM_WIN32)
#   include <Common/Base/Fwd/hkwindows.h>
#   if defined(HK_PLATFORM_DURANGO)
#       include <consoleid.h>
#       include <Common/Base/Container/String/hkUtf8.h>




#   endif
#elif defined(HK_PLATFORM_PS4)
#   include <system_service.h>
#elif defined(HK_PLATFORM_IOS)
#   import <sys/types.h>
#   import <sys/sysctl.h>
#endif

const char* hkPlatformInfo::getPlatformName()
{
    return HK_PLATFORM_STRING;
}

const char* hkPlatformInfo::getOperatingSystemName()
{
    return HK_OPERATING_SYSTEM_STRING;
}

const char* hkPlatformInfo::getArchitectureName()
{
    return hkHardwareInfo::getArchitectureName();
}

const char* hkPlatformInfo::getDeviceName( hkStringPtr& nameOut )
{
    
#define ___UNDEF_GENERIC_DEVICE_NAME "Unknown " HK_PP_STRINGIFY_VALUE( HK_PLATFORM_STRING )

#if defined(HK_PLATFORM_WIIU) || defined(HK_PLATFORM_CTR) || defined(HK_PLATFORM_PSVITA) || defined(HK_PLATFORM_UWP) || \
    defined(HK_PLATFORM_NX)
    nameOut = ___UNDEF_GENERIC_DEVICE_NAME;
#elif defined(HK_PLATFORM_WIN32) || defined(HK_PLATFORM_DURANGO) || defined(HK_PLATFORM_PS4) || defined(HK_PLATFORM_MAC) || \
        defined(HK_PLATFORM_LINUX) || defined(HK_PLATFORM_IOS) || defined(HK_PLATFORM_TVOS) || defined(HK_PLATFORM_ANDROID) || \
        defined(HK_PLATFORM_TIZEN)
#   if defined(HK_PLATFORM_WIN32)
#       if defined(HK_PLATFORM_DURANGO)
            WCHAR nameBuffer[CONSOLE_ID_CCH];
            HRESULT res = GetConsoleId( nameBuffer, HK_COUNT_OF( nameBuffer ) );
            if ( res != S_OK )
            {
                nameOut = ___UNDEF_GENERIC_DEVICE_NAME;
            }
            else
            {
                hkStringBuf buf = hkUtf8::Utf8FromWide( nameBuffer );
                buf.append( " (" HK_PLATFORM_STRING ")" );
                nameOut = buf;
            }
#       else
            DWORD nameBufferSize = 128;
            CHAR nameBuffer[128];
            if ( GetComputerNameA( nameBuffer, &nameBufferSize ) )
            {
                nameOut = nameBuffer;
            }
#       endif
#   elif defined(HK_PLATFORM_PS4)
        char nameBuffer[128];
        int32_t res = sceSystemServiceParamGetString( SCE_SYSTEM_SERVICE_PARAM_ID_SYSTEM_NAME, nameBuffer, HK_COUNT_OF( nameBuffer ) );
        if ( res < 0 )
        {
            nameOut = ___UNDEF_GENERIC_DEVICE_NAME;
        }
        else
        {
            hkStringBuf buf = nameBuffer;
            buf.append( " (" HK_PLATFORM_STRING ")" );
            nameOut = buf;
        }
#   elif defined(HK_PLATFORM_IOS)
        size_t size;
        sysctlbyname( "hw.machine", NULL, &size, NULL, 0 );
        char* machineHwName = hkAllocate<char>( size, HK_MEMORY_CLASS_DISPLAY );
        sysctlbyname( "hw.machine", machineHwName, &size, NULL, 0 );
        if ( hkString::strCmp( machineHwName, "iPhone1,1" ) == 0 ) nameOut = "Unknown iPhone"; // Orig
        else if ( hkString::strCmp( machineHwName, "iPhone1,2" ) == 0 ) nameOut = "Unknown iPhone 3G";
        else if ( hkString::strCmp( machineHwName, "iPhone2,1" ) == 0 ) nameOut = "Unknown iPhone 3GS";
        else if ( hkString::strStr( machineHwName, "iPhone" ) != NULL ) nameOut = "Unknown iPhone 3GS, or higher";
        else if ( hkString::strCmp( machineHwName, "iPod1,1" ) == 0 ) nameOut = "Unknown iPod Touch"; // Orig
        else if ( hkString::strCmp( machineHwName, "iPod2,1" ) == 0 ) nameOut = "Unknown iPod Touch 2G";
        else if ( hkString::strCmp( machineHwName, "iPod3,1" ) == 0 ) nameOut = "Unknown iPod Touch 3G"; //?
        else if ( hkString::strStr( machineHwName, "iPod" ) != NULL ) nameOut = "Unknown iPod Touch 3G, or higher";
        else if ( hkString::strCmp( machineHwName, "i386" ) == 0 ) nameOut = "iPhone Simulator";
        else nameOut = ___UNDEF_GENERIC_DEVICE_NAME;
        hkDeallocate<char>( machineHwName );
#   else
        nameOut = ___UNDEF_GENERIC_DEVICE_NAME;
#   endif
#else
#   warning Could not autodetect platform for device name
    nameOut = ___UNDEF_GENERIC_DEVICE_NAME;
#endif

#undef ___UNDEF_GENERIC_DEVICE_NAME

    return nameOut;
}

const char* hkPlatformInfo::getSimdSupportString()
{
    return hkHardwareInfo::getSimdSupportString();
}

const char* hkPlatformInfo::getCompilerName()
{
    return HK_COMPILER_STRING;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
