// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : COMMON
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/System/Log/hkLogJsonOutput.h>
#include <Common/Base/Serialize/Util/Json/hkJson.h>

namespace
{
    const char* const s_LogLevelString[] =
    {
        "Disabled",
        "Error",
        "Warning",
        "Info",
        "Dev",
        "Debug",
        "MaxLevel"
    };
}

namespace hkLog
{

JsonOutput::JsonOutput( hkJsonOstream& output, Level::Enum level )
    : Output(level)
    , m_output( output )
{
}

Output::Action JsonOutput::put( const Message& msg )
{
    if ( msg.m_txt.isNullOrEmpty() )
    {
        return Action::PropagateToNextOutput;
    }

    if ( msg.m_level > getLevel() )
    {
        return Action::PropagateToNextOutput;
    }

    m_output.beginObject();
    m_output.writePair( "origin", msg.m_origin.getName() );
    m_output.writePair( "id", msg.m_id );
    m_output.writePair( "level", s_LogLevelString[ int(msg.m_level) ] );
    m_output.writePair( "text", msg.m_txt.cString() );
    m_output.writePair( "file", msg.m_locFilename );
    m_output.writePair( "line", msg.m_locLine );
    m_output.writePair( "column", msg.m_locColumn );
    m_output.end();

    return Action::PropagateToNextOutput;
}

} // namespace hkLog

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
