// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

    /// A generic interface to writing a stream of bytes.
    /// The reader may optionally support buffering or may be
    /// wrapped as a child stream of an hkBufferedStreamWriter.
class HK_EXPORT_COMMON hkStreamWriter : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_STREAM);

        hkStreamWriter() {}
            /// Return false if end of file has been reached or some other error.
            /// Otherwise return true.
        virtual hkBool isOk() const = 0;

            /// Write nbytes. Returns the number of bytes written.
            /// The number of bytes returned may be less than nbytes
            /// (in the case of nonblocking sockets for instance).
        virtual _Ret_range_(0, nbytes) int write(_In_reads_bytes_(nbytes) const void* buf, int nbytes) = 0;

        template<typename DST, typename SRC>
        int write1As(SRC src)
        {
            DST dst = hkLosslessCast<DST>(src);
            return write(&dst, sizeof(DST));
        }

            /// Flush any internal buffers.
        virtual void flush() { }

            /// Return true if seeking is supported on this stream. By default not supported.
        virtual hkBool seekTellSupported() const;

            /// Parameter for seek method.
        enum SeekWhence { STREAM_SET=0, STREAM_CUR=1, STREAM_END=2 };

            /// Seek to offset from whence.
        virtual hkResult seek(int offset, SeekWhence whence);

            /// Get the current file offset if supported or -1 on error.
            /// Default implementation calls seek(0, STREAM_CUR);
        virtual int tell() const;

        virtual hkBool isBuffered() const;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
