// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

/// Writer which is a "window" into another stream.
/// Write requests are simply forwarded. Seek/tell
/// requests are offset before forwarding so that the
/// start (tell() == 0) of the substream is at a
/// specified offset in the child stream.
class HK_EXPORT_COMMON hkSubStreamWriter : public hkStreamWriter
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
            /// Substream starts at the child's current offset.
        hkSubStreamWriter(_Inout_ hkStreamWriter* child)
            : m_childStream( child )
        {
            HK_ASSERT_NO_MSG( 0xaa36a77f, child );
            m_startOffset = m_childStream->tell();
        }

            /// The zero offset is at the specified offset into child.
        hkSubStreamWriter(_Inout_ hkStreamWriter* child, int offset )
            : m_childStream( child ), m_startOffset(offset)
        {
            HK_ASSERT_NO_MSG( 0xaa36a77f, child );
        }

        virtual hkBool isOk() const
        {
            return m_childStream->isOk();
        }

        virtual _Ret_range_(0, nbytes) int write(_In_reads_bytes_(nbytes) const void* buf, int nbytes)
        {
            return m_childStream->write( buf, nbytes );
        }

        virtual void flush()
        {
            m_childStream->flush();
        }

        virtual hkBool seekTellSupported() const
        {
            return m_childStream->seekTellSupported();
        }

        virtual hkResult seek(int offset, hkStreamWriter::SeekWhence whence)
        {
            int realOffset = ( whence == STREAM_SET )
                ? m_startOffset + offset
                : offset;

            return m_childStream->seek( realOffset, whence );
        }

        virtual int tell() const
        {
            return m_childStream->tell() - m_startOffset;
        }

    protected:

        hkStreamWriter* m_childStream;
        int m_startOffset;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
