// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/Writer/OffsetOnly/hkOffsetOnlyStreamWriter.h>

hkOffsetOnlyStreamWriter::hkOffsetOnlyStreamWriter()
    : m_offset(0), m_eofOffset(0)
{
}

hkBool hkOffsetOnlyStreamWriter::isOk() const
{
    return true;
}

_Ret_range_(0, n) int hkOffsetOnlyStreamWriter::write(_In_reads_bytes_(n) const void*, int n)
{
    m_offset += n;
    m_eofOffset = m_offset > m_eofOffset ? m_offset : m_eofOffset;
    return n;
}

hkBool hkOffsetOnlyStreamWriter::seekTellSupported() const
{
    return true;
}

hkResult hkOffsetOnlyStreamWriter::seek(int offset, SeekWhence whence)
{
    switch(whence)
    {
        case hkStreamWriter::STREAM_SET:
            m_offset = offset;
            break;
        case STREAM_CUR:
            m_offset += offset;
            break;
        case STREAM_END:
            m_offset = m_eofOffset - offset;
            break;
        default:
            HK_ASSERT(0x783b0cbf, 0, "Unknown seek type given to fake stream writer.");
    }
    m_eofOffset = m_offset > m_eofOffset ? m_offset : m_eofOffset;
    HK_ASSERT(0x50df405e, m_offset >= 0, "Underflow in seek() on fake stream writer." );
    return HK_SUCCESS;
}

int hkOffsetOnlyStreamWriter::tell() const
{
    return m_offset;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
