// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

    /// Write to a fixed size memory block.
class HK_EXPORT_COMMON hkMemoryStreamWriter : public hkStreamWriter
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_STREAM);

            /// The memory is not cleared before writing.
            /// Normally this is not a problem, but if you plan to perform random access with seek(),
            /// you may want to clear the buffer.
        hkMemoryStreamWriter(_In_bytecount_(bufSize) void* buf, int bufSize) : m_buf(buf), m_bufSize(bufSize), m_cur(0) {}

        virtual _Ret_range_(0, nb) int write(_In_reads_bytes_(nb) const void* b, int nb);

        virtual hkBool isOk() const;

        virtual hkBool seekTellSupported() const;
        virtual int tell() const;
        virtual hkResult seek(int offset, SeekWhence whence);

    protected:

        void* m_buf;
        int m_bufSize;
        int m_cur;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
