// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

    /// This writer compares written data to an existing buffer.
    /// If a difference is encountered, an internal flag is set and can be checked with isOk().
    /// Additionally, if set in the constructor a breakpoint may be issued.
    /// Note that an explicit close() call is needed after the final write and before the final isOk() check.
    /// This is needed to detect a shorter write than the original buffer.
class HK_EXPORT_COMMON hkMemCmpStreamWriter : public hkStreamWriter
{
public:
    HK_DECLARE_CLASS(hkMemCmpStreamWriter, New);

    enum OnDifference
    {
        DIFFERENCE_FLAG,
        DIFFERENCE_BREAKPOINT
    };

    hkMemCmpStreamWriter(_In_reads_bytes_(l) const void* p, int l, OnDifference ondiff);

    virtual hkBool isOk() const HK_OVERRIDE;

    virtual _Ret_range_(0, n) int write(_In_reads_bytes_(n) const void*, int n) HK_OVERRIDE;

    virtual int tell() const HK_OVERRIDE;

    void close();

protected:

    const void* m_base;
    const void* m_cur;
    const void* m_end;
    bool m_ok;
    OnDifference m_onDifference;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
