// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/Writer/MemCmp/hkMemCmpStreamWriter.h>

hkMemCmpStreamWriter::hkMemCmpStreamWriter(_In_reads_bytes_(l) const void* p, int l, OnDifference ondiff)
    : m_base(p)
    , m_cur(p)
    , m_end(hkAddByteOffset(p, l))
    , m_ok(true)
    , m_onDifference(ondiff)
{
}


hkBool hkMemCmpStreamWriter::isOk() const
{
    return m_ok;
}


_Ret_range_(0, nbytes) int hkMemCmpStreamWriter::write(_In_reads_bytes_(nbytes) const void* buf, int nbytes)
{
    if(m_ok)
    {
        hkLong remain = hkGetByteOffset(m_cur, m_end);
        if(nbytes > remain)
        {
            if(m_onDifference == DIFFERENCE_BREAKPOINT)
            {
                HK_BREAKPOINT(0);
            }

            // too much written
            m_ok = false;
            return hkLosslessCast<int>(remain);
        }

        if(hkString::memCmp(buf, m_cur, nbytes) != 0)
        {
            if(m_onDifference == DIFFERENCE_BREAKPOINT)
            {
                for(int i = 0; i < nbytes; ++i)
                {
                    if(((const char*)buf)[i] != ((const char*)m_cur)[i]) HK_BREAKPOINT(0);
                }
            }

            // bytes differ here
            m_ok = false;
            return nbytes;
        }

        m_cur = hkAddByteOffset(m_cur, nbytes);
        return nbytes;
    }
    return -1;
}


int hkMemCmpStreamWriter::tell() const
{
    return hkLosslessCast<int>( hkGetByteOffset(m_base, m_cur) );
}


void hkMemCmpStreamWriter::close()
{
    if(m_ok)
    {
        m_ok = (m_end == m_cur); // check we're both at eof!
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
