// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/Algorithm/Hash/hkHash.h>

template<typename T, T poly>
hkCrcStreamWriter<T, poly>::hkCrcStreamWriter(T startCrc)
: m_crc(startCrc ^ T(-1))
{
}

template<typename T, T poly>
T hkCrcStreamWriter<T, poly>::calcPermute(T p)
{
    for( int i = 0; i < 8; ++i )
    {
        if( p & 1 )
        {
            p = poly ^ (p >> 1);
        }
        else
        {
            p = p >> 1;
        }
    }
    return p;
}

template<typename T, T poly>
_Ret_range_(0, nbytes) int hkCrcStreamWriter<T, poly>::write(_In_reads_bytes_(nbytes) const void* ptr, int nbytes)
{
    const hkUint8* buf = static_cast<const hkUint8*>(ptr);
    T crc = m_crc;
    for( int n = 0; n < nbytes; ++n)
    {
        T permute = calcPermute( (crc ^ buf[n]) & 0xff );
        crc = permute ^ (crc >> 8);
    }
    m_crc = crc;
    return nbytes;
}

template<typename T, T poly>
T hkCrcStreamWriter<T, poly>::getCrc() const
{
    return m_crc ^ T(-1);
}

// Specialize the template for crc32 to use the look-up table-based implementation from hkHash.
template<>
inline _Ret_range_(0, nbytes) int hkCrcStreamWriter<hkUint32, 0xedb88320>::write(_In_reads_bytes_(nbytes) const void* ptr, int nbytes )
{
    m_crc = hkHash::appendCrc32( m_crc ^ hkUint32(-1), ptr, nbytes ) ^ hkUint32(-1);
    return nbytes;
}

// Specialize the template for crc64 to use the look-up table-based implementation from hkHash.
template<>
inline _Ret_range_(0, nbytes) int hkCrcStreamWriter<hkUint64, 0xc96c5795d7870f42ull>::write(_In_reads_bytes_(nbytes) const void* ptr, int nbytes )
{
    m_crc = hkHash::appendCrc64( m_crc ^ hkUint64(-1), ptr, nbytes ) ^ hkUint64(-1);
    return nbytes;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
