// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

/// A generic CRC (Cylic Redundancy Check) class.
template<typename T, T poly>
class hkCrcStreamWriter : public hkStreamWriter
{
    public:
        inline hkCrcStreamWriter( T startCrc = 0 );
        virtual hkBool isOk() const HK_OVERRIDE { return true; }
        virtual _Ret_range_(0, n) int write(_In_reads_bytes_(n) const void*, int n) HK_OVERRIDE;

            /// Get the crc from the writer.
        inline T getCrc() const;

        static inline T calcPermute( T p );
        virtual int tell() const HK_OVERRIDE { return -1; }

    protected:
        T m_crc;
};

/// CRC32
class hkCrc32StreamWriter : public hkCrcStreamWriter<hkUint32, 0xedb88320>
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        inline hkCrc32StreamWriter( hkUint32 startCrc = 0 ) : hkCrcStreamWriter<hkUint32, 0xedb88320>( startCrc ) {}
};

/// CRC64
class hkCrc64StreamWriter : public hkCrcStreamWriter<hkUint64, 0xc96c5795d7870f42ull>
{
public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
    inline hkCrc64StreamWriter( hkUint64 startCrc = 0 ) : hkCrcStreamWriter<hkUint64, 0xc96c5795d7870f42ull>( startCrc ) {}
};

#include <Common/Base/System/Io/Writer/Crc/hkCrcStreamWriter.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
