// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

    /// Wraps and compresses an existing stream
class HK_EXPORT_COMMON hkCompressedStreamWriter : public hkStreamWriter
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
            /// Create a buffered stream from stream 's' with block size 'blockSize'.
            /// Adds a reference to 's'.
            /// To support seek/tell, the data will only be compressed when this stream writer is destroyed, as opposed to on-the-fly.
            /// This means that bufSize is used only as an initial size, not a limit, in the case of seek/tell support; the buffer is
            /// allowed to grow by an unlimited amount to accommodate the uncompressed data.
        hkCompressedStreamWriter(_Inout_ hkStreamWriter* s, hkBool seekTellSupported=false, int bufSize=(1<<16));

            /// Removes a reference to its sub stream.
        ~hkCompressedStreamWriter();

        virtual _Ret_range_(0, nbytes) int write(_In_reads_bytes_(nbytes) const void* buf, int nbytes);

        virtual void flush();

        virtual hkBool isOk() const;

        virtual hkBool seekTellSupported() const;

            /// Seek to offset from whence. Seeking past the length of the stream is not supported.
        virtual hkResult seek(int offset, SeekWhence whence);

            /// Get the current file offset if supported or -1 on error.
        virtual int tell() const;

    protected:

        void writeBlock();

        hkStreamWriter* m_stream;
        hkBool m_ok;
        int m_bufSize;

        hkUchar* m_uncompbuf;
        int m_uncompbufsize;
        int m_uncompbufpos;
        int m_uncomplen;

        hkBool m_seekTellSupported;

        hkUint32 m_totalwritten;
        hkUint32 m_crc;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
