// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE

#pragma once

#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

    /// Wraps and buffers an existing unbuffered stream.
class HK_EXPORT_COMMON hkBufferedStreamWriter : public hkStreamWriter
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
            /// Create a buffered stream from stream 's' with size 'bufSize'.
            /// If bufSize is -1 a default value is chosen.
            /// Adds a reference to 's'.
        hkBufferedStreamWriter(_Inout_opt_ hkStreamWriter* s, int bufSize = -1);

            /// Create a buffered stream from a piece of memory 'm' with size 'memSize'.
            /// The memory is used in place and must be valid for the lifetime of this object.
            /// If the memory is to be used to hold a C string, it is zeroed and the final byte
            /// will not be written to which ensures the string is always terminated.
        hkBufferedStreamWriter(_Out_writes_bytes_(memSize) void* mem, int memSize, hkBool memoryIsString);

            /// Removes a reference to its sub stream.
        ~hkBufferedStreamWriter();

        virtual _Ret_range_(0, nbytes) int write(_In_reads_bytes_(nbytes) const void* buf, int nbytes) HK_OVERRIDE;

        virtual void flush() HK_OVERRIDE;

        virtual hkBool isOk() const HK_OVERRIDE;

        virtual hkBool seekTellSupported() const HK_OVERRIDE;

        virtual hkResult seek(int offset, SeekWhence whence) HK_OVERRIDE;

        virtual int tell() const HK_OVERRIDE;

        virtual hkBool isBuffered() const HK_OVERRIDE;

    protected:

        hkStreamWriter* m_stream; // child stream or HK_NULL for inplace
        char* m_buf; // start of buffer area
        int m_bufSize; // used buffer area
        int m_bufCapacity; // total available buffer area
        hkBool m_ownBuffer; // did we allocate the buffer

    protected:

        int flushBuffer();
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
