// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Reader/hkStreamReader.h>
class hkMemoryAllocator;
class hkStringPtr;
class hkStringBuf;
class hkIstream;

    /// Utility class to
class HK_EXPORT_COMMON hkLoadUtil
{
    public:

        HK_DECLARE_PLACEMENT_ALLOCATOR();

        //
        // inputs
        //

            /// Load from the hkFileSystem singleton.
        hkLoadUtil(_In_opt_z_ const char* fname);

            /// Load from the given hkStreamReader.
        hkLoadUtil(_Inout_ hkStreamReader* sr);

            /// Load from the given hkIstream
        hkLoadUtil( hkIstream& is );

            ///
        ~hkLoadUtil();


        //
        // outputs
        //

            /// Read into an hkArray::Temp
        bool toArray( hkArray<char>::Temp& out );

            /// Read into a heap hkArray
        bool toArray( hkArray<char>& out );

            ///
        bool toArray( hkArrayBase<char>& out, hkMemoryAllocator& mem );


            /// Read into a newly allocated block. Free with mem.blockFree(p, sizeOut)
        _Ret_maybenull_ void* toAllocation(_Out_ int* sizeOut, hkMemoryAllocator& mem );

            /// Get as a null terminated string.
        bool toString( hkStringBuf& buf );

            /// Get as a null terminated string.
        bool toString( hkStringPtr& buf );

            /// Get as a null-terminated string. The return value is the length of
            /// the string. The buffer is always terminated. Thus the return value
            /// is at most bufSize-1.
        int toString(_Out_writes_bytes_(bufSize) char* buf, int bufSize );

    private:

        const char* m_fileName;
        hkRefPtr<hkStreamReader> m_reader;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
