// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/Util/hkCopyUtil.h>
#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>

bool hkIo::copyStream(_Inout_ hkStreamReader* srcStream, _Inout_ hkStreamWriter* dstStream)
{
    /// 16384 bytes as buffer size is just random number, no meanings behind it
    const int BUF_SIZE = 16384;
    unsigned char buf[BUF_SIZE];

    while (int bytesRead = srcStream->read(buf, BUF_SIZE))
    {
        int bytesWritten = 0;
        while (bytesWritten < bytesRead)
        {
            bytesWritten += dstStream->write(buf + bytesWritten, bytesRead - bytesWritten);

            if (!dstStream->isOk())
            {
                return false;
            }
        }

        if (!srcStream->isOk())
        {
            return false;
        }
    }

    return true;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
