// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/Structured/hkStructuredStream.h>

void hkSerialize::HffWriter::openScope(ScopeType s, Ident id)
{
    HK_ASSERT_NO_MSG(0x1fa0df2e, m_scopes.getSize() == 0 || m_scopes.back().type() == BRANCH);
    HK_ASSERT(0x391a6fe3, id != IDENT_NONE && id != IDENT_IO_ERROR, "Don't use reserved ident");
    m_scopes.pushBack(Scope(s, m_buf.tell()));
    m_buf.writePod<hkUint32Be>(-1);
    m_buf.writePod<hkUint32Be>(id);
}

void hkSerialize::HffWriter::closeScope()
{
    Scope scope = m_scopes.back(); m_scopes.popBack();
    hkLong start = scope.off();
    hkLong end = m_buf.tell();
    m_buf.writePodAt<hkUint32Be>(start, pack(scope.type(), end - start));
}

void hkSerialize::HffWriter::writeLeaf(Ident id, _In_reads_bytes_(len) const void* buf, hkInt32 len)
{
    openScope(LEAF, id);
    m_buf.writeRaw(buf, len);
    closeScope();
}

hkSerialize::HffBuilder::~HffBuilder()
{
}


struct hkSerialize::HffMemoryBuilder::Buffer : public hkIo::WriteBuffer
{
    HK_DECLARE_CLASS(Buffer, New);
    Buffer() { attach(&m_storage); }
    hkArray<char> m_storage;
};


hkSerialize::HffMemoryBuilder::~HffMemoryBuilder()
{
    reset();
}

void hkSerialize::HffMemoryBuilder::reset()
{
    for( int i = 0; i < m_nodes.getSize(); ++i )
    {
        if( Buffer* b = m_nodes[i].buf )
        {
            delete b;
        }
    }
    m_nodes.clear();
    m_closed = false;
}

hkSerialize::HffBuilder::BranchId hkSerialize::HffMemoryBuilder::openBranch(BranchId parent, Ident id)
{
    HK_ASSERT_NO_MSG(0x6fbf7fcb, parent!=-1 || m_nodes.getSize()==0);
    HK_ASSERT_NO_MSG(0x324a3e, parent==-1 || m_nodes[parent].buf==HK_NULL);
    HK_ASSERT_NO_MSG(0x2d7c077, !m_closed);
    int r = m_nodes.getSize();
    m_nodes.pushBack(Node(id,parent,HK_NULL));
    return r;
}


hkIo::WriteBuffer* hkSerialize::HffMemoryBuilder::openLeaf(BranchId parent, Ident id)
{
    HK_ASSERT_NO_MSG(0xa12e314, parent!=-1 || m_nodes.getSize()==0);
    HK_ASSERT_NO_MSG(0x1a5bae98, !m_closed);
    Buffer* b = new Buffer();
    m_nodes.pushBack(Node(id,parent,b));
    return b;
}

namespace
{
    struct NodeTmp
    {
        NodeTmp() : size(0) {}
        hkArray<int> children;
        hkLong size;
    };
}

void hkSerialize::HffMemoryBuilder::close()
{
    HK_ASSERT_NO_MSG(0x774dc04e, !m_closed);
    m_closed = true;
}

void hkSerialize::HffMemoryBuilder::writeTo(const hkIo::Detail::WriteBufferAdapter& sink)
{
    HK_ASSERT_NO_MSG(0x241fcdc9, m_closed);
    if( m_nodes.getSize() == 0 ) // degenerate empty stream
    {
        return;
    }
    hkIo::WriteBuffer buf(sink);

    // Walk through all nodes, remember buffers & propagate sizes/offsets etc up to parent nodes
    hkArray<NodeTmp>::Temp nodetmp; nodetmp.setSize(m_nodes.getSize());

    // find children of each node
    for( int i = 0; i < m_nodes.getSize(); ++i )
    {
        const HffMemoryBuilder::Node& n = m_nodes[i];
        if(n.parent != -1 )
        {
            nodetmp[n.parent].children.pushBack(i);
        }
    }

    // bubble sizes up
    struct Local
    {
        enum { MIN_ALIGNMENT=1 };
        const hkArray<Node>& m_src;
        hkArray<NodeTmp>::Temp& m_dst;
        Local(const hkArray<Node>& src, hkArray<NodeTmp>::Temp& dst) : m_src(src), m_dst(dst) {}

        hkUlong computeSize( int curIdx )
        {
            const Node& src = m_src[curIdx];
            NodeTmp& dst = m_dst[curIdx];
            if( src.buf )
            {
                HK_ASSERT_NO_MSG(0x23fcb3d4, dst.children.getSize()==0);
                src.buf->detach();
                if( hkLong size = src.buf->m_storage.getSize() ) // prune empty
                {
                    dst.size = 8 + size;
                    return HK_NEXT_MULTIPLE_OF(MIN_ALIGNMENT, dst.size);
                }
                return 0;
            }
            else
            {
                hkUlong size = 0;
                for( int i = 0; i < dst.children.getSize(); ++i )
                {
                    size += computeSize( dst.children[i] );
                }
                if( size ) // prune empty
                {
                    dst.size = 8 + size;
                    return HK_NEXT_MULTIPLE_OF(MIN_ALIGNMENT, dst.size);
                }
                return 0;
            }
        }

        void write(hkIo::WriteBuffer& wb, int curIdx)
        {
            const Node& src = m_src[curIdx];
            NodeTmp& dst = m_dst[curIdx];
            if( dst.size == 0 )
            {
                return;
            }
            else if( src.buf )
            {
                wb.writePod<hkUint32Be>( pack(LEAF, dst.size) );
                wb.writePod<hkUint32Be>(src.id);
                HK_ASSERT_NO_MSG(0x50ad38d0, dst.size == 8+src.buf->m_storage.getSize());
                wb.writeRaw( src.buf->m_storage.begin(), src.buf->m_storage.getSize() );
                while( src.buf->m_storage.getSize() & (MIN_ALIGNMENT-1) )
                {
                    wb.writePod<char>(0);
                }
            }
            else
            {
                HK_ON_DEBUG( hkLong start = wb.tell() );
                wb.writePod<hkUint32Be>( pack(BRANCH, dst.size) );
                wb.writePod<hkUint32Be>(src.id);
                for( int i = 0; i < dst.children.getSize(); ++i )
                {
                    write(wb, dst.children[i]);
                }
                HK_ON_DEBUG(hkLong end = wb.tell());
                HK_ASSERT_NO_MSG(0x7bc40a87, end-start == dst.size);
            }
        }

        void walk(hkIo::WriteBuffer& wb)
        {
            computeSize(0);
            write(wb,0);
        }
    };
    Local(m_nodes, nodetmp).walk(buf);
    reset();
}

void hkSerialize::HffMemoryBuilder::walkOver(Callback cb, _Inout_opt_ void* cbArg)
{
    for(int i = 0; i < m_nodes.getSize(); ++i)
    {
        const Node& n = m_nodes[i];
        if(n.buf)
        {
            (*cb)(n.id, n.buf->m_storage.begin(), n.buf->tell(), cbArg);
        }
    }
}

hkResult _index(hkArray<hkSerialize::Detail::HffSection>& out, _In_reads_bytes_(len) const void* buf, hkLong len, hkUint32 off)
{
    using namespace hkSerialize;

    while(len >= 2 * sizeof(hkUint32Be))
    {
        hkUint32Be packed = static_cast<const hkUint32Be*>(buf)[0];
        hkUint32Be ident = static_cast<const hkUint32Be*>(buf)[1];
        hkUint32 size = hkSerialize::unpackb(packed);
        hkUint32 type = hkSerialize::unpacks(packed);
        if(type != 0 && type != 1)
        {
            return HK_FAILURE; // unknown scope type
        }

        if(hkLong(size) <= len)
        {
            hkSerialize::Detail::HffSection& s = out.expandOne();
            s.m_ident = ident;
            s.m_size = size;
            s.m_offset = off;
            s.m_isLeaf = type != 0;

            if(s.m_isLeaf)
            {
                buf = hkAddByteOffset(buf, size);
                len -= size;
                off += size;
            }
            else
            {
                buf = hkAddByteOffset(buf, 8);
                len -= 8;
                off += 8;
            }
        }
        else
        {
            return HK_FAILURE; // truncated data
        }
    }
    return (len == 0) ? HK_SUCCESS : HK_FAILURE;
}


hkResult hkSerialize::Detail::indexHff(hkArray<HffSection>& out, _In_reads_bytes_(len) const void* buf, hkLong len)
{
    return _index(out, buf, len, 0);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
