// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

/// A class representing an IPv4 inet address (ip + port).
class HK_EXPORT_COMMON hkInetAddr
{
public:
    HK_DECLARE_CLASS( hkInetAddr, New, Reflect );
    HK_RECORD_ATTR( hk::ToString( &hkInetAddr::toLogString ) );

    // Construct with both address and port set to zero.
    hkInetAddr();

    // Construct from a NBO (network-byte-order/big-endian) addr and an HBO (host-byte-order) port.
    hkInetAddr( hkInt32 ipAddressNbo, hkUint16 port );

    void operator= ( const hkInetAddr &other );
    int operator== ( const hkInetAddr &other ) const;

    /// Return the addr + port packed into an unsigned 64-bit integer.
    hkUint64 toUint64() const;

    enum
    {
        MAX_STRING_LEN = sizeof( "xxx.yyy.zzz.www:ppppp" )
    };

    /// Return a string which represents the inet addr of the form "x.y.z.w:port".
    _Ret_z_ const char* toString( _Inout_updates_z_( MAX_STRING_LEN ) char buf[MAX_STRING_LEN], hkBool includePort = true ) const;

    /// Format an inet addr var as a string for use in hkLog and other formatting.
    /// Format the address as "x.y.z.w:port".
    static void HK_CALL toLogString( const hkReflect::Var& var, hkStringBuf& sb, const hkStringView& extra );

    /// Convert a string of the form "x.y.z.w" (and optionally with ":port") to an inet addr.
    static hkInetAddr HK_CALL fromString( const char* ipAddress );

    /// Get a loopback inet addr for the provided port in HBO (host-byte-order).
    static hkInetAddr HK_CALL getLoopbackAddr( hkUint16 port );

    /// Get a broadcast inet addr for the provided port in HBO (host-byte-order) and optional subnet in NBO (network-byte-order/big-endian).
    static hkInetAddr HK_CALL getBroadcastAddr( hkUint16 port, hkInt32 subnetNbo = 0xffffffff );

public:

    /// The IPv4 ip address in network-byte-order (NBO) (big endian).
    hkInt32 m_ipAddress;

    /// The port in host-byte-order (HBO).
    hkUint16 m_port;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
