// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/Socket/hkInetAddr.h>
#include <Common/Base/Container/LocalArray/hkLocalArray.h>

hkInetAddr::hkInetAddr()
    : m_ipAddress( 0 ),
    m_port( 0 )
{}

hkInetAddr::hkInetAddr( hkInt32 ipAddressNbo, hkUint16 port )
    : m_ipAddress( ipAddressNbo ),
    m_port( port )
{}

void hkInetAddr::operator= ( const hkInetAddr &other )
{
    m_ipAddress = other.m_ipAddress;
    m_port = other.m_port;
}

int hkInetAddr::operator== ( const hkInetAddr &other ) const
{
    return m_ipAddress == other.m_ipAddress && m_port == other.m_port;
}

hkUint64 hkInetAddr::toUint64() const
{
    return ( hkUint64( m_ipAddress ) << 32 ) | m_port;
}

_Ret_z_ const char* hkInetAddr::toString( _Inout_updates_z_( MAX_STRING_LEN ) char buf[MAX_STRING_LEN], hkBool includePort ) const
{
    unsigned char* ucp = ( unsigned char * ) &m_ipAddress;
    if ( includePort )
    {
        hkString::snPrintf( buf, MAX_STRING_LEN, MAX_STRING_LEN, "%d.%d.%d.%d:%d", ucp[0] & 0xff, ucp[1] & 0xff, ucp[2] & 0xff, ucp[3] & 0xff, m_port );
    }
    else
    {
        hkString::snPrintf( buf, MAX_STRING_LEN, MAX_STRING_LEN, "%d.%d.%d.%d", ucp[0] & 0xff, ucp[1] & 0xff, ucp[2] & 0xff, ucp[3] & 0xff );
    }
    return buf;
}

void hkInetAddr::toLogString( const hkReflect::Var& var, hkStringBuf& sb, const hkStringView& extra )
{
    const hkInetAddr* const addr = var.dynCast<hkInetAddr>();
    const hkUint32 ip = addr->m_ipAddress;
    sb.formatL( HK_VARARGS1_WRAP( ( "{}.{}.{}.{}:{}", ip & 0xff, ( ip & 0xff00 ) >> 8, ( ip & 0xff0000 ) >> 16, ( ip & 0xff000000 ) >> 24, addr->m_port ) ) ); 
}

hkInetAddr HK_CALL hkInetAddr::fromString( const char* ipAddress )
{
    hkInt32 addr = 0;
    hkUint16 port = 0;

    hkArray<hkStringView> addrPortTokens;
    hkString::tokenize( ipAddress, ":", " ", addrPortTokens );
    if ( addrPortTokens.getSize() )
    {
        hkArray<hkStringView> addrTokens;
        hkString::tokenize( addrPortTokens[0].begin(), ".", " ", addrTokens );
        int addrLength = hkString::strLen( addrPortTokens[0].begin() );
        hkLocalArray<char> addrStorage( addrLength + 1 );
        if ( addrTokens.getSize() == 4 )
        {
            for ( int i = 0; i < 4; i++ )
            {
                addrStorage.setSize( addrTokens[i].getSize() + 1 );
                addrTokens[i].copy( addrStorage.begin(), addrStorage.getSize(), addrStorage.getSize() );
                addrStorage[addrStorage.getSize() - 1] = '\0';
                int addrToken = hkString::atoi( addrStorage.begin() );
                addr += hkUint8( addrToken ) << ( 8 * ( i ) );
            }
        }
        if ( addrPortTokens.getSize() > 1 ) port = hkUint16( hkString::atoi( addrPortTokens[1].begin() ) );
    }

    return hkInetAddr( addr, port );
}

hkInetAddr HK_CALL hkInetAddr::getLoopbackAddr( hkUint16 port )
{
    hkInt32Be addr = 0x0100007f;
    return hkInetAddr( addr, port );
}

hkInetAddr HK_CALL hkInetAddr::getBroadcastAddr( hkUint16 port, hkInt32 subnetNbo )
{
    return hkInetAddr( subnetNbo, port );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
