// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Reader/hkStreamReader.h>

/// Wraps a reader around a memory fragment.
class HK_EXPORT_COMMON hkMemoryStreamReader : public hkInplaceStreamReader
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
            ///
        enum MemoryType
        {
            MEMORY_COPY,
            MEMORY_TAKE,
            MEMORY_INPLACE
        };

            /// Create a stream from the specified memory.
            /// If MemoryType is MEMORY_COPY, the memory is copied into
            /// an internal buffer and freed on destruction.
            /// MEMORY_TAKE will take ownership of the memory (which was
            /// allocated with hkAllocate) and hkDeallocate it on destruction.
            /// MEMORY_INPLACE will use the memory in place
            /// and must exist for the lifetime of this object.
            /// A baseOffset may be given, which means that seek and tell will
            /// consider mem to have position "baseOffset".
        hkMemoryStreamReader(_In_reads_bytes_(memSize) const void* mem, int memSize, MemoryType t, hkLong baseOffset=0);

        ~hkMemoryStreamReader();

        virtual hkLong available() HK_OVERRIDE { return m_bufSize - m_bufCurrent; }

        virtual _Ret_range_(0, nbytes) int read(_Out_writes_bytes_(nbytes) void* buf, int nbytes) HK_OVERRIDE;

        virtual _Ret_range_(0, nbytes) int skip(int nbytes) HK_OVERRIDE;

        virtual hkBool isOk() const HK_OVERRIDE;

        virtual _Ret_range_(0, nbytes) int peek(_Out_writes_bytes_(nbytes) void* buf, int nbytes) HK_OVERRIDE;

        virtual hkResult seek(int offset, SeekWhence whence) HK_OVERRIDE;

        virtual int tell() const HK_OVERRIDE;

        virtual hkArrayView<void> peekInto(hkUlong nbytes) const HK_OVERRIDE;

    protected:

        char* m_buf;
        int m_bufCurrent; // current byte index
        int m_bufSize; // end of usable buffer size
        hkLong m_baseOffset;
        MemoryType m_memType; // owned or referenced
        hkBool m_hitEof;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
