// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/Reader/Memory/hkMemoryStreamReader.h>

hkMemoryStreamReader::hkMemoryStreamReader(_In_reads_bytes_(memSize) const void* mem, int memSize, MemoryType mt, hkLong baseOffset)
    :   m_bufCurrent(0),
        m_bufSize(memSize),
        m_baseOffset(baseOffset),
        m_memType(mt),
        m_hitEof(false)
{
    if( m_memType == MEMORY_COPY )
    {
        m_buf = hkAllocate<char>( memSize, HK_MEMORY_CLASS_STREAM );
        hkString::memCpy( m_buf, mem, memSize );
    }
    else
    {
        m_buf = const_cast<char*>(static_cast<const char*>(mem));
    }
}

hkMemoryStreamReader::~hkMemoryStreamReader()
{
    if( m_memType == MEMORY_COPY || m_memType == MEMORY_TAKE )
    {
        hkDeallocate<char>(m_buf);
    }
}

_Ret_range_(0, nbytes) int hkMemoryStreamReader::read(_Out_writes_bytes_(nbytes) void* buf, int nbytes)
{
    int nread = hkMath::min2(m_bufSize - m_bufCurrent, nbytes);
    hkString::memCpy(buf, m_buf+m_bufCurrent, nread );
    m_bufCurrent += nread;
    if( nread == 0 && nbytes != 0 )
    {
        m_hitEof = true;
    }
    return nread;
}

_Ret_range_(0, nbytes) int hkMemoryStreamReader::skip(int nbytes)
{
    int nread = hkMath::min2(m_bufSize - m_bufCurrent, nbytes);
    m_bufCurrent += nread;
    if( nread == 0 && nbytes != 0 )
    {
        m_hitEof = true;
    }
    return nread;
}

hkBool hkMemoryStreamReader::isOk() const
{
    return m_hitEof == false;
}

_Ret_range_(0, nbytes) int hkMemoryStreamReader::peek(_Out_writes_bytes_(nbytes) void* buf, int nbytes)
{
    int nread = hkMath::min2(m_bufSize - m_bufCurrent, nbytes);
    hkMemUtil::memCpy( buf, m_buf+m_bufCurrent, nread);
    return nread;
}

hkResult hkMemoryStreamReader::seek(int relOffset, SeekWhence whence)
{
    int pos = -1;
    switch(whence)
    {
        case STREAM_SET:
            pos = relOffset - hkLosslessCast<int>(m_baseOffset);
            break;
        case STREAM_CUR:
            pos = m_bufCurrent + relOffset;
            break;
        case STREAM_END:
            pos = m_bufSize - relOffset;
            break;
    }
    hkResult ok = HK_SUCCESS;
    if( pos < 0 )
    {
        pos = 0;
        ok = HK_FAILURE;
    }
    else if( pos > m_bufSize )
    {
        pos = m_bufSize;
        ok = HK_FAILURE;
    }
    m_bufCurrent = pos;
    m_hitEof = false;
    return ok;
}

int hkMemoryStreamReader::tell() const
{
    return hkLosslessCast<int>(m_bufCurrent + m_baseOffset);
}

hkArrayView<void> hkMemoryStreamReader::peekInto(hkUlong nbytes) const
{
    int navail = hkMath::min2(m_bufSize - m_bufCurrent, nbytes);
    return hkArrayView<void>(m_buf + m_bufCurrent, navail);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
