// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/System/Io/Writer/Crc/hkCrcStreamWriter.h>

class HK_EXPORT_COMMON hkCrcStreamReader : public hkSeekableStreamReader
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_STREAM);

        hkCrcStreamReader(_In_ hkSeekableStreamReader* underlyingStream) : m_underlyingStream(underlyingStream) {}
        virtual ~hkCrcStreamReader() {}

        virtual hkBool isOk() const HK_OVERRIDE;
        virtual _Ret_range_(0, nbytes) int read(_Out_writes_bytes_(nbytes) void* buf, int nbytes) HK_OVERRIDE;
        virtual _Ret_range_(0, nbytes) int skip(int nbytes) HK_OVERRIDE;
        virtual _Ret_range_(0, nbytes) int peek(_Out_writes_bytes_(nbytes) void* buf, int nbytes) HK_OVERRIDE;

        virtual _Ret_maybenull_ hkSeekableStreamReader* isSeekTellSupported() HK_OVERRIDE { return this; }

        virtual hkResult seek(int offset, hkSeekableStreamReader::SeekWhence whence) HK_OVERRIDE;
        virtual int tell() const HK_OVERRIDE;

        hkUint32 getCrc() const { return m_crc.getCrc(); }



    protected:
        hkRefPtr<hkSeekableStreamReader> m_underlyingStream;
        hkCrc32StreamWriter m_crc;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
