// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Reader/hkStreamReader.h>

    /// Wraps an existing stream, uncompressing the underlying stream's data.
class HK_EXPORT_COMMON hkCompressedStreamReader : public hkStreamReader
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);

            /// Calls constructor after checking stream header is error-free, else returns failure.
        static hkResult make(_Inout_ hkRefPtr<hkStreamReader>& s);

            /// Removes reference to the reader in the constructor if applicable.
        ~hkCompressedStreamReader();

        virtual _Ret_range_(0, nbytes) int read(_Out_writes_bytes_opt_(nbytes) void* buf, int nbytes);

        virtual _Ret_range_(0, nbytes) int skip(int nbytes);

        virtual _Ret_range_(0, nbytes) int peek(_Out_writes_bytes_opt_(nbytes) void* buf, int nbytes);

        virtual hkBool isOk() const;

        // Neither mark/rewind nor seek/tell are supported

    private:
            /// Create a compressed stream from stream 's'.
            /// Adds a reference to 's'.
        hkCompressedStreamReader(_Inout_ hkStreamReader* s);

    protected:

        hkResult loadNewBlock();
        hkResult loadFooter();

        hkStreamReader* m_stream; // child stream
        hkBool m_ok;

        hkUchar* m_compbuf; // buffer for compressed data
        hkUchar* m_uncompbuf; // buffer for uncompressed data

        int m_uncomppos;
        int m_uncomplen;
        int m_uncompbufsize;

        int m_compbufpos;
        int m_compbuflen;
        int m_compbufsize;

        hkUint32 m_totalread;
        hkUint32 m_crc;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
