// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Reader/hkStreamReader.h>

    /// Wraps and buffers an existing unbuffered stream.
    /// This takes care of any alignment requirements from the underlying stream
    /// (e.g. read only multiples of N bytes, read to M-byte-aligned addresses).
    /// A side effect of buffering is that peek() becomes available.
class HK_EXPORT_COMMON hkBufferedStreamReader : public hkSeekableStreamReader
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
            /// Create a buffered stream from stream 's' with size 'bufSize'.
            /// If bufSize is -1 a default value is chosen.
            /// Adds a reference to 's'.
        hkBufferedStreamReader(_Inout_ hkStreamReader* s, int bufSize=-1);

            /// Removes reference to the reader in the constructor if applicable.
        ~hkBufferedStreamReader();

        virtual _Ret_range_(0, nbytes) int read(_Out_writes_bytes_(nbytes) void* buf, int nbytes);

        virtual _Ret_range_(0, nbytes) int skip(int nbytes);

        virtual _Ret_range_(0, nbytes) int peek(_Out_writes_bytes_(nbytes) void* buf, int nbytes);

        virtual hkBool isOk() const;

        virtual _Ret_maybenull_ hkSeekableStreamReader* isSeekTellSupported();

        virtual hkResult seek( int offset, SeekWhence whence);

        virtual int tell() const;

    protected:

        hkStreamReader* m_stream; // child stream
        hkSeekableStreamReader* m_seekStream; // set only if child stream is seekable

        struct Buffer
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE_CLASS, hkBufferedStreamReader::Buffer );

            Buffer(int cap);
            ~Buffer();
            char* begin;
            int current; // current byte index
            int size; // end of usable buffer size - only less than capacity on short read
            int capacity; // buffer region is begin,begin+m_capacity
        };

        Buffer m_buf;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
