// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 METRO_X86 METRO_X64 METRO_ARM APOLLO_X86 APOLLO_ARM DURANGO UWP OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

    // This writes files in shared mode so they can be read
    // before the file handle has been closed (useful mainly for debugging)
class hkWin32StreamWriter : public hkStreamWriter
{
    public:
        typedef void* HANDLE;

        static _Ret_maybenull_ hkWin32StreamWriter* open(_In_z_ const char* fname, int dwCreationDisposition = 2 /*CREATE_ALWAYS*/, bool shared = true /*FILE_SHARE_READ*/);

        hkWin32StreamWriter(HANDLE handle);
        virtual ~hkWin32StreamWriter();
        void close();

        virtual _Ret_range_(0, nbytes) int write(_In_reads_bytes_(nbytes) const void* buf, int nbytes);
        virtual void flush();
        virtual hkBool isOk() const;

        virtual hkBool seekTellSupported() const { return true; }
        virtual hkResult seek( int offset, SeekWhence whence);
        virtual int tell() const;

    protected:

        HANDLE m_handle;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
