// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 METRO_X86 METRO_X64 METRO_ARM APOLLO_X86 APOLLO_ARM DURANGO UWP OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/Platform/Win32/hkWin32StreamWriter.h>
#include <Common/Base/Fwd/hkwindows.h>
#include <Common/Base/Container/String/hkUtf8.h>

#if defined(HK_PLATFORM_WINRT) || (_WIN32_WINNT >= 0x0602 )
#   define _USE_EX_FILEIO 1
#endif

_Ret_maybenull_
hkWin32StreamWriter* hkWin32StreamWriter::open(_In_z_ const char* fname, int dwCreationDisposition, bool shared)
{
    for (int numTries = 1000; numTries >= 0; numTries--)
    {
#ifdef _USE_EX_FILEIO
        HANDLE handle = CreateFile2( hkUtf8::WideFromUtf8(fname).cString(), GENERIC_WRITE, shared ? FILE_SHARE_READ : 0, dwCreationDisposition, HK_NULL );
#else
        HANDLE handle = CreateFileW( hkUtf8::WideFromUtf8(fname).cString(), GENERIC_WRITE, shared ? FILE_SHARE_READ : 0, HK_NULL, dwCreationDisposition, FILE_ATTRIBUTE_NORMAL, HK_NULL );
#endif
        if ( handle != INVALID_HANDLE_VALUE )
        {
            return new hkWin32StreamWriter(handle);
        }

        // Invalid handle. Check the error
        const DWORD lastErr = GetLastError();
        if ( lastErr != ERROR_SHARING_VIOLATION )
        {
            break;
        }

        // We have a sharing violation, wait for a bit and try again
#if !defined(HK_PLATFORM_WINRT)
        Sleep(100);
#endif
    }

    return HK_NULL;
}

hkWin32StreamWriter::hkWin32StreamWriter(HANDLE handle)
    : m_handle(handle)
{
}

void hkWin32StreamWriter::close()
{
    if(m_handle != INVALID_HANDLE_VALUE)
    {
        CloseHandle(m_handle);
    }
}

hkWin32StreamWriter::~hkWin32StreamWriter()
{
    close();
}

_Ret_range_(0, nbytes) int hkWin32StreamWriter::write(_In_reads_bytes_(nbytes) const void* buf, int nbytes)
{
    if( (m_handle != INVALID_HANDLE_VALUE) && nbytes > 0 )
    {
        DWORD n;
        WriteFile( m_handle, buf, nbytes, &n, HK_NULL );
        if( n <= 0 )
        {
            close();
        }
        return n;
    }
    return 0;
}

void hkWin32StreamWriter::flush()
{
    if( m_handle != INVALID_HANDLE_VALUE )
    {
        FlushFileBuffers(m_handle);
    }
}

hkBool hkWin32StreamWriter::isOk() const
{
    return m_handle != INVALID_HANDLE_VALUE;
}

hkResult hkWin32StreamWriter::seek( int offset, SeekWhence whence)
{
#ifdef _USE_EX_FILEIO
    DWORD moveType[] = {FILE_BEGIN,FILE_CURRENT, FILE_END};
    LARGE_INTEGER newPos;
    LARGE_INTEGER offsetL; offsetL.QuadPart = offset;
    BOOL ok = SetFilePointerEx(m_handle, offsetL, &newPos, moveType[(int)whence]);
    return ok ? HK_SUCCESS : HK_FAILURE;
#else
    return SetFilePointer(m_handle, offset, HK_NULL, whence) != INVALID_SET_FILE_POINTER ? HK_SUCCESS : HK_FAILURE;
#endif
}

int hkWin32StreamWriter::tell() const
{
#ifdef _USE_EX_FILEIO
    LARGE_INTEGER newPos;
    LARGE_INTEGER offsetL; offsetL.QuadPart = 0;
    BOOL ok = SetFilePointerEx(m_handle, offsetL, &newPos, FILE_CURRENT);
    return ok? (int)( newPos.LowPart ) : 0;
#else
    DWORD off = SetFilePointer(m_handle, 0, HK_NULL, FILE_CURRENT);
    return off != INVALID_SET_FILE_POINTER ? off : -1;
#endif
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
