// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 DURANGO OSINTERNAL
// PRODUCT    : COMMON
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>
class Win32FileSystemWatcher;

class HK_EXPORT_COMMON hkWin32FileSystem : public hkFileSystem
{
    friend class Win32FileSystemWatcher;
    public:
        /// Gets location of temp directory.
        static hkResult getTempDir(hkStringBuf& tempDirOut);

        /// Creates a unique temporary directory. Created directory should be deleted by caller when they are done with it.
        static hkResult createTempSubDir(hkStringBuf& tempDirOut);

        /// Removes a file or an empty (!) directory.
        virtual hkResult remove(_In_z_ const char* path) HK_OVERRIDE;
        virtual hkResult mkdir(_In_z_ const char* path, CreateFlag flag) HK_OVERRIDE;
        virtual hkResult moveFile(_In_z_ const char* sourceFile, _In_z_ const char* destPath) HK_OVERRIDE;
        virtual hkResult copy(_In_z_ const char* srcPath, _In_z_ const char* dstPath);

        virtual hkResult stat(_In_z_ const char* path, Entry& entryOut ) HK_OVERRIDE;
        virtual hkRefNew<Iterator::Impl> createIterator(_In_z_ const char* top, _In_z_ const char* wildcard ) HK_OVERRIDE;

        virtual hkRefNew<Watcher> createWatcher(_In_z_ const char* topDirectory) HK_OVERRIDE;

        virtual _Ret_maybenull_z_ const char* getOperatingSystemPath(_In_z_ const char* pathIn, hkStringBuf& pathOut, OSPathFlags flags ) HK_OVERRIDE;

        class WatcherImpl;
private:
        virtual hkRefNew<hkStreamReader> _openReader(_In_z_ const char* name, OpenFlags flags) HK_OVERRIDE;
        virtual hkRefNew<hkStreamWriter> _openWriter(_In_z_ const char* name, OpenFlags flags) HK_OVERRIDE;

        hkRefPtr<WatcherImpl> m_watcherImpl;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
