// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 METRO_X86 METRO_X64 METRO_ARM APOLLO_X86 APOLLO_ARM DURANGO UWP OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/Platform/Win32/hkDebugConsoleStreamWriter.h>
#include <Common/Base/Fwd/hkcstdio.h>

#if defined(HK_PLATFORM_WIN32)
#   include <Common/Base/Fwd/hkwindows.h>
#else
#   error debug console is only for win32
#endif

_Ret_range_(0, nbytes) int hkDebugConsoleStreamWriter::write(_In_reads_bytes_(nbytes) const void* buf, int nbytes)
{
    // careful about accessing buf[-1]
    if(nbytes!=0)
    {
        const char* cbuf = static_cast<const char*>(buf);
        if (cbuf[nbytes - 1] == '\0')
        {
            OutputDebugStringA( cbuf );
            printf("%s", cbuf);
        }
        else
        {
            hkArray<char> wbuf(nbytes+1);
            hkArray<char>::copy( &wbuf[0], cbuf, nbytes);
            wbuf[nbytes] = '\0';
            OutputDebugStringA( &wbuf[0] );
            printf("%s", &wbuf[0]);
        }
    }

    return nbytes;
}

hkBool hkDebugConsoleStreamWriter::isOk() const
{
    return true;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
