// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 PS4 DURANGO OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/System/Io/Writer/hkStreamWriter.h>
#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>

class HK_EXPORT_COMMON hkStdioStreamWriter : public hkStreamWriter
{
    public:

            /// Open the file for write. If the OPEN_TRUNCATE flag is specified, fopen will be called in "wb" mode.
            /// If the flag is not specified, fopen will be called in "r+b" mode if the file exists, or "w+b" if not.
        static _Ret_maybenull_ hkStdioStreamWriter* HK_CALL open(_In_z_ const char* name, hkFileSystem::OpenFlags flags);

        hkStdioStreamWriter(_In_ void* /*FILE**/ handle, hkBool shouldClose);
        virtual ~hkStdioStreamWriter();

        void close();

        virtual _Ret_range_(0, nbytes) int write(_In_reads_bytes_(nbytes) const void* buf, int nbytes);
        virtual void flush();
        virtual hkBool isOk() const;
        virtual hkBool seekTellSupported() const;
        virtual hkResult seek( int offset, SeekWhence whence);
        virtual int tell() const;

    protected:

        void* m_handle;
        hkBool m_shouldClose;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
