// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 PS4 DURANGO OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/Platform/Stdio/hkStdioStreamWriter.h>
#include <Common/Base/Fwd/hkcstdio.h>

using namespace std;

_Ret_maybenull_ hkStdioStreamWriter* hkStdioStreamWriter::open(_In_z_ const char* name, hkFileSystem::OpenFlags flags)
{

    FILE* f;

    if( flags & hkFileSystem::OPEN_TRUNCATE )
    {
        f = fopen( name, "wb" );
    }
    else
    {
        // Try to open for read/update first
        f = fopen(name, "r+b");

        // If that fails (file didn't exist), open for write/update
        if(!f)
        {
            f = fopen(name, "w+b");
        }
    }

    if(f)
    {
        return new hkStdioStreamWriter(f, true);
    }
    else
    {
        return HK_NULL;
    }
}


hkStdioStreamWriter::hkStdioStreamWriter(_In_ void* handle, hkBool shouldClose)
    :   m_handle(handle), m_shouldClose(shouldClose)
{
}

void hkStdioStreamWriter::close()
{
    if(m_handle != HK_NULL && m_shouldClose)
    {
        fclose( (FILE*)m_handle);
    }
    m_handle = HK_NULL;
}

hkStdioStreamWriter::~hkStdioStreamWriter()
{
    close();
}

_Ret_range_(0, nbytes) int hkStdioStreamWriter::write(_In_reads_bytes_(nbytes) const void* buf, int nbytes)
{
    if( m_handle != HK_NULL && nbytes > 0 )
    {
        int n = static_cast<int>( fwrite( buf, 1, nbytes, (FILE*)m_handle ) );
        if( n <= 0 )
        {
            close();
        }
        return n;
    }
    return 0;
}

void hkStdioStreamWriter::flush()
{
    if( m_handle != HK_NULL )
    {
        fflush( (FILE*)m_handle );
    }
}

hkBool hkStdioStreamWriter::isOk() const
{
    return m_handle != HK_NULL;
}

hkBool hkStdioStreamWriter::seekTellSupported() const
{
    return true;
}

hkResult hkStdioStreamWriter::seek( int offset, SeekWhence whence)
{
    return fseek((FILE*)m_handle, offset, whence) == 0
        ? HK_SUCCESS
        : HK_FAILURE;
}

int hkStdioStreamWriter::tell() const
{
    return ftell((FILE*)m_handle);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
