// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : LINUX32 LINUX64 WIN32 X64 METRO_X86 METRO_X64 METRO_ARM APOLLO_ARM APOLLO_X86 DURANGO UWP
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Reader/hkStreamReader.h>

class HK_EXPORT_COMMON hkStdioStreamReader : public hkSeekableStreamReader
{
    public:
        static _Ret_maybenull_ hkStdioStreamReader* HK_CALL open(_In_z_ const char* nameIn);

        hkStdioStreamReader( /*FILE*/_In_  void* handle);
        virtual ~hkStdioStreamReader();

        virtual _Ret_range_(0, nbytes) int read(_Out_writes_bytes_(nbytes) void* buf, int nbytes);
        virtual hkBool isOk() const;
        virtual _Ret_range_(0, nbytes) int peek(_Out_writes_bytes_(n) void* buf, int n);

        virtual hkResult seek( int offset, SeekWhence whence);
        virtual int tell() const;

    protected:

        void* m_handle; //FILE*
        hkBool m_isOk;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
