// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/Platform/Stdio/hkStdioPipeStreamWriter.h>
#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>
#include <Common/Base/Fwd/hkcstdio.h>

hkStdioPipeStreamWriter* hkStdioPipeStreamWriter::open( const char* command )
{
    FILE* f = _popen(command, "wb");

    if(f)
    {
        return new hkStdioPipeStreamWriter(f, true);
    }
    else
    {
        return HK_NULL;
    }
}


hkStdioPipeStreamWriter::hkStdioPipeStreamWriter(void* handle, hkBool shouldClose)
    :   m_handle(handle), m_shouldClose(shouldClose)
{
}

void hkStdioPipeStreamWriter::close()
{
    if(m_handle != HK_NULL && m_shouldClose)
    {
        _pclose( (FILE*)m_handle);
    }
    m_handle = HK_NULL;
}

hkStdioPipeStreamWriter::~hkStdioPipeStreamWriter()
{
    close();
}

int hkStdioPipeStreamWriter::write( const void* buf, int nbytes)
{
    if( m_handle != HK_NULL && nbytes > 0 )
    {
        int n = static_cast<int>( fwrite( buf, 1, nbytes, (FILE*)m_handle ) );
        if( n <= 0 )
        {
            close();
        }
        return n;
    }
    return 0;
}

void hkStdioPipeStreamWriter::flush()
{
}

hkBool hkStdioPipeStreamWriter::isOk() const
{
    return m_handle != HK_NULL;
}

hkBool hkStdioPipeStreamWriter::seekTellSupported() const
{
    return false;
}

hkResult hkStdioPipeStreamWriter::seek( int offset, SeekWhence whence)
{
    return HK_FAILURE;
}

int hkStdioPipeStreamWriter::tell() const
{
    return 0;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
