// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : NX32 NX64 !REFLECT
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Writer/hkStreamWriter.h>
#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>

#include <nn/fs/fs_File.h>

class hkNxStreamWriter : public hkStreamWriter
{
    public:

        static hkNxStreamWriter* open(const char* name, hkFileSystem::OpenFlags flags);

        hkNxStreamWriter(nn::fs::FileHandle handle, hkBool shouldClose);

        void close();
        virtual ~hkNxStreamWriter();
        virtual int write( const void* buf, int nbytes);
        virtual void flush();
        virtual hkBool isOk() const;

        virtual hkBool seekTellSupported() const;
        virtual hkResult seek( int offset, SeekWhence whence);
        virtual int tell() const;

    protected:

        nn::fs::FileHandle m_handle;
        hkBool m_shouldClose;
        int64_t m_offset;  // current position
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
