// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : NX32 NX64 !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Reader/hkStreamReader.h>

#include <nn/fs.h>

class HK_EXPORT_COMMON hkNxStreamReader : public hkSeekableStreamReader
{
    public:
        static hkNxStreamReader* HK_CALL open( const char* nameIn );

        hkNxStreamReader( nn::fs::FileHandle& handle );
        virtual ~hkNxStreamReader();

        virtual int read( void* buf, int nbytes);
        virtual hkBool isOk() const;
        virtual int peek(void* buf, int n);

        virtual hkResult seek( int offset, SeekWhence whence);
        virtual int tell() const;

        int getSize() const { return (int)m_size; }

    protected:

        nn::fs::FileHandle m_handle; //FILE*
        hkBool m_isOk;
        int64_t m_offset;  // current position
        int64_t m_size;  // file size
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
